package com.rocogz.syy.operation.dto.quotapply;


import com.rocogz.syy.operation.entity.quotapply.OperateQuotaConfigAccount;
import com.rocogz.syy.operation.enums.QuotaApplyModeEnum;
import com.rocogz.syy.operation.enums.QuotaManageModeEnum;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 填写 额度申请页面, 主体额度账号 可用额度信息
 *
 * @author zhangmin
 */
@Setter
@Getter
public class QuotaApplyAvailableQuotaInfoVo {

    /**
     * 主体code
     */
    private String issueBodyCode;

    /**
     * 主体简称
     */
    private String issueBodyAbbreviation;

    /**
     * 主体关联的合作客户:电子账户额度管理模式
     *
     * 电子账户上:额度管理模式(VIRTUAL_MODE:虚拟额度;RESERVE_PAYMENT:备付金)
     */
    private QuotaManageModeEnum quotaManageMode;

    /**
     * 主体配置表中的配置的 额度管理模式
     * @see OperateQuotaConfigAccount#quotaManageMode
     */
    private QuotaManageModeEnum cfgQuotaManageMode;

    /**
     *
     * 额度申请模式
     * OPERATOR_PROXY("运营代申请"),  ISSUING_BODY_SELF("主体自己申请");
     * 主体上配置
     * @see OperateQuotaConfigAccount#applyMode
     */
    private QuotaApplyModeEnum applyMode;


    /**
     * 发放主体额度主体账号，例如：NUMA000000001
     */
    private String issueBodyAcctNo;


    /**
     * 可用额度，额度余额:主体账户
     *
     * 主体账户:剩余额度 SettleAccount.balanceAmount
     */
    private BigDecimal availableQuota;

    /**
     * 总额度:主体账户
     *
     * 发放主体账户:总额度 SettleAccount.totalAmount
     *
     */
    private BigDecimal totalQuota;

    /**
     * 已使用额度: 主体账户
     * 主体账户:已发放+已冻结  settleAccount.issuedAmount +  SettleAccount.freezeAmount
     */
    private BigDecimal usedQuota;

    /**
     * 已冻结额度
     */
    private BigDecimal frozenQuota;

    /**
     * 合作客户编号:主体上
     */
    private String customerCode;

    /**
     * 合作客户简称
     */
    private String customerAbbreviation;

    /**
     * 额度转换备付金 兑换比例 合作客户上的
     */
    private BigDecimal quotaConversionRatio;

    /**
     * 额度申请人用户名
     */
    private String applierUser;

    /**
     * 额度申请人名字
     */
    private String applierName;

    /**
     * 申请人手机号
     */
    private String applierMobile;


    /**
     * 申请人可用的费用类型
     * （1) 主体自己申请取 申请人配置的费用类型
     * （2）运营代申请 取发放主体的费用类型
     */
    private List<String> availableFeeTypeCodes;

}