package com.rocogz.syy.operation.dto.settle;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class DetailDto {

    /**
     * 结算明细id
     */
    Integer id;

    /**
     * 结算申请单
     */
    Integer settleId;

    /**
     * 结算申请单
     */
    String settleNo;

    /**
     * 供应商编码
     */
    String supplierCode;

    /**
     * 供应商
     */
    String supplierName;

    /**
     * 客户编码
     */
    String customerCode;

    /**
     * 客户
     */
    String customerName;
    
    /**
     * 发放单号
     */
    String applyNo;

    /**
     * 发放清单明细id
     */
    Integer applyId;

    /**
     * 发放单明细编码
     */
    String code;

    /**
     * 主体业务类型
     */
    String issuingBodyBusinessType;

    /**
     * 主体业务类型
     */
    String issuingBodyBusinessName;

    /**
     * 供应商产品编号
     */
    String platformProductCode;

    /**
     * 供应商产品编号
     */
    String platformProductName;

    /**
     * ERP产品编号
     */
    String erpGoodsCode;

    /**
     * 客户产品编号
     */
    String customerProductCode;

    /**
     * 客户产品名称
     */
    String customerProductame;

    /**
     * 单位面值
     */
    BigDecimal unitFaceValue;

    /**
     * 市场价
     */
    BigDecimal marketPrice;

    /**
     * 成本价
     */
    BigDecimal costPrice;

    /**
     * 采购结算单价价
     */
    BigDecimal purchaseSettlePrice;

    /**
     * 发放数量
     */
    Integer quantity;

    /**
     * 结算金额
     */
    BigDecimal settleAmount;

    /**
     * 发放月份
     */
    String grantMonth;

    /**
     * 发放时间
     */
    LocalDateTime grantTime;

    /**
     * 发放人
     */
    String granter;

    /**
     * 发放人
     */
    String granterName;

    /**
     * 发放人工号
     */
    String granterNo;

    /**
     * 发放人所在机构编码
     */
    String granterBelongOrgCode;

    /**
     * 发放人所在机构
     */
    String granterBelongOrgName;

    /**
     * 领取时间
     */
    LocalDateTime receiveTime;

    /**
     * 发放单状态
     */
    String status;

    /**
     * 结算状态
     */
    String settleStatus;

    /**
     * 产品类别
     */
    String couponTypeCode;

    /**
     * 产品类型
     */
    String goodsType;


    /**
     * 产品类别
     */
    String couponTypeName;

    /**
     * 产品类型
     */
    String goodsTypeName;

    /**
     * 发放明细状态名称
     */
    String statusName;

    /**
     * 结算状态名称
     */
    String settleStatusName;
}
