package com.rocogz.syy.operation.dto.settle;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettleDistributionDto implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * id
     */
    private Integer id;

    /**
     * 结算申请单
     */
    private String settleDistributionNo;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商
     */
    private String supplierName;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户
     */
    private String customerName;

    /**
     * 结算单状态
     */
    private String status;

    /**
     * 结算明细状态
     */
    private String detailSettleStatus;

    /**
     * 结算对冲状态
     */
    private String rDetailSettleStatus;

    /**
     * 结算金额
     */
    private BigDecimal settleAmount;

    /**
     * 实际结算金额
     */
    private BigDecimal realSettleAmount;

    /**
     * 对冲金额
     */
    private BigDecimal hedgingAmount;

    /**
     * 申请时间
     */
   
    private LocalDateTime applyTime;

    /**
     * 审批人
     */
    private String applyer;

    /**
     * 创建人名字
     */
    private String applyerName;

    /**
     * 审批时间
     */
   
    private LocalDateTime approveTime;

    /**
     * 审批人
     */
    private String approver;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审核意见
     */
    private String approveCommente;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人名字
     */
    private String createUserName;

    /**
     * 更新人
     */
    private String updateUser;
    /**
     * 修改人名字
     */
    private String updateUserName;
   
    private LocalDateTime createTime;
   
    private LocalDateTime updateTime;

    /**
     * 结算笔数
     */
    private Integer settleNum;

    /**
     * 对冲笔数
     */
    private Integer hedgingNum;

    /**
     * 结算总笔数
     */
    private Integer settleSum;

    /**
     * 到账时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    private LocalDate receiveTime;

    /**
     * 清单查询开始时间
     */
    private LocalDateTime settleStartTime;

    /**
     * 清单查询结束时间
     */
    private LocalDateTime settleEndTime;

    /**
     * 结算明细
     */
    private List<SettleDistributionDetailDto> detailList;

    /**
     * 对冲明细
     */
    private List<SettleDistributionReturnDetailDto> returnDetailList;

    /**
     * 操审核记录
     */
    private List<SettleDistributionLogDto> operateList;

    /**
     * 导出明细标识
     */
    private String exportFlag;

    /**
     * 发放明细状态名称
     */
    String statusName;

}
