package com.rocogz.syy.operation.dto.settle;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class SettleDistributionReq{

    /**
     * 结算申请单
     */
    private String settleDistributionNo;

    /**
     * 供应商编码
     */
    private List<String> supplierCodes;

    /**
     * 客户编码
     */
    private List<String> customerCodes;

    /**
     * 结算单状态
     */
    private String status;

    /**
     * 创建查询开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTimeMinTime;

    /**
     * 创建查询结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTimeMaxTime;

    /**
     * 审核查询开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime approveTimeMinTime;

    /**
     * 审核查询结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime approveTimeMaxTime;

    /**
     * 结算查询开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime receiveTimeMinTime;

    /**
     * 结算查询结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime receiveTimeMaxTime;
    /**
     * 第几页
     */
    private int page=1;

    /**
     * 没有大小
     */
    private int limit=10;

}
