package com.rocogz.syy.operation.entity.car.dealer;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.entity.label.OperateLabel;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 4S店表
 * </p>
 * @author 陈煜敏
 * @since 2022-12-06
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_car_dealer_shop")
public class OperateCarDealerShop extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 4S店编码
     */
    private String code;

    /**
     * 4S店业内名称
     */
    private String name;

    /**
     * 4S店营业执照名称
     */
    private String licenseName;

    /**
     * 4S店标准规范名称
     */
    private String standardName;

    /**
     * 集团编码
     */
    private String blocCode;

    /**
     * 集团名称
     */
    @TableField(exist = false)
    private String blocName;

    /**
     * 集团简称
     */
    @TableField(exist = false)
    private String blocAbbreviationName;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 4S店成立日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    private LocalDate openingDate;

    /**
     * 4S店经营年限
     */
    private String businessLife;

    /**
     * 4S店经营性质
     */
    private String businessNature;

    /**
     * 4S店管理特征
     */
    private String manageCharacter;

    /**
     * 4S店区域口碑
     */
    private String regionReputation;

    /**
     * 主要汽车品牌
     */
    private String carBrand;

    /**
     * 是否有业务合作：Y-是，N-否
     */
    private String cooperation;

    /**
     * 业务合作范围
     */
    private String cooperationArea;

    /**
     * 4S店情况说明
     */
    private String remark;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 4S店标签
     */
    @TableField(exist = false)
    private List<OperateLabel> labels;

}
