package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 交互动作记录对象entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_interactive_object")
public class OperateInteractiveObject extends IdEntity {

    private static final long serialVersionUID = -80114972245173628L;

    /**
    * 交互动作记录code
    */
    private String interactiveRecordCode;
    
    /**
    * 姓名
    */
    private String name;
    
    /**
    * 岗位
    */
    private String job;
    
    /**
    * 负责内容
    */
    private String responsibleBusiness;
    
    /**
    * 主要观点
    */
    private String opinion;
    
    /**
    * 个人情况
    */
    private String persionalInfo;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;
}