package com.rocogz.syy.operation.entity.car.dealer;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: 销售线索entity
 * @date：2022/12/08
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("operate_sale_clew")
public class OperateSaleClew extends IdEntity {

    private static final long serialVersionUID = -91008915659786580L;

    /**
    * 编号
    */
    private String code;
    
    /**
    * 来源种子code
    */
    private String fissionSeedCode;
    
    /**
    * 线索4S店集团code
    */
    private String blocCode;
    
    /**
    * 线索4S店code
    */
    private String shopCode;
    
    /**
    * 关键人姓名
    */
    private String keyPersonName;
    
    /**
    * 关键人手机号
    */
    private String keyPersonMobile;
    
    /**
    * 关键人性别（常量：MALE-男、FEMALE-女）
    */
    private String keyPersonGender;
    
    /**
    * 关键人工作岗位
    */
    private String keyPersonJob;
    
    /**
    * 在店工作年限
    */
    private String serviceYear;

    /**
     * 线索提供年份
     */
    private String clewOfferYear;

    /**
     * 线索提供月份
     */
    private String clewOfferMonth;
    
    /**
    * 线索提供日期
    */
    private LocalDate clewOfferDate;
    
    /**
    * 业务负责情况
    */
    private String responsibleBusiness;
    
    /**
    * 线索说明
    */
    private String clewDescription;

    /**
     * 线索阶段 （字典，字典编号：CLEW_STAGE）
     */
    private String clewStage;

    /**
     * 线索策略 （字典，字典编号：CLEW_STRATEGY）
     */
    private String clewStrategy;
    
    /**
    * 线索推进情况（字典，字典编号：CLEW_ADVANCE_STATUS_TYPE）
    */
    private String clewAdvanceStatus;
    
    /**
    * 线索转换情况（字典，字典编号：CLEW_CONVERSION_STATUS_TYPE）
    */
    private String clewConversionStatus;
    
    /**
    * 首次联系日期
    */
    private LocalDate firstContactDate;
    
    /**
    * 推进人姓名
    */
    private String promoterName;
    
    /**
    * 推进人手机号
    */
    private String promoterMobile;
    
    /**
    * 推进日期
    */
    private LocalDate promoterDate;

    /**
    * 转化成功日期
    */
    private LocalDate conversionSuccessDate;

    /**
    * 转化说明
    */
    private String conversionDescription;

    /**
     * 关闭人姓名
     */
    private String closeName;

    /**
     * 关闭日期
     */
    private LocalDate closeDate;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 更新时间
    */
    private LocalDateTime updateTime;
    
    /**
    * 更新人
    */
    private String updateUser;

    /**
     * 关闭人昵称
     */
    @TableField(exist = false)
    private String closeNickName;

    /**
     * 所属4S店集团店
     */
    @TableField(exist = false)
    private OperateCarDealerBloc bloc;

    /**
     * 所属4S店
     */
    @TableField(exist = false)
    private OperateCarDealerShop shop;

    /**
     * 来源种子
     */
    @TableField(exist = false)
    private OperateFissionSeed fissionSeed;

    /**
     * 所属4S店集团简称
     */
    @TableField(exist = false)
    private String blocAbbreviationName;
    /**
     * 所属4S店集团简称
     * 供操作日志记录使用
     */
    public String getBlocAbbreviationName(){
        if(StringUtils.isNotBlank(blocAbbreviationName)){
            return blocAbbreviationName;
        }
        if(this.bloc != null){
            return this.bloc.getAbbreviationName();
        }
        return null;
    }

    /**
     * 所属4S店行业内名称
     */
    @TableField(exist = false)
    private String shopName;

    /**
     * 所属4S店行业内名称
     * 供操作日志记录使用
     */
    public String getShopName(){
        if(StringUtils.isNotBlank(shopName)){
            return shopName;
        }
        if(this.shop != null){
            return this.shop.getName();
        }
        return null;
    }

    /**
     * 来源种子姓名
     */
    @TableField(exist = false)
    private String fissionSeedName;

    /**
     * 来源种子姓名
     * 供操作日志记录使用
     */
    public String getFissionSeedName(){
        if(StringUtils.isNotBlank(fissionSeedName)){
            return fissionSeedName;
        }
        if(this.fissionSeed != null){
            return this.fissionSeed.getName();
        }
        return null;
    }

    /**
     * 来源种子手机号
     */
    @TableField(exist = false)
    private String fissionSeedMobile;

    /**
     * 来源种子手机号
     * 供操作日志记录使用
     */
    public String getFissionSeedMobile(){
        if(StringUtils.isNotBlank(fissionSeedMobile)){
            return fissionSeedMobile;
        }
        if(this.fissionSeed != null){
            return this.fissionSeed.getMobile();
        }
        return null;
    }

}