package com.rocogz.syy.operation.entity.inverst;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.dto.inverst.OperateWithdrawExamPaperDbDto;
import com.rocogz.syy.operation.dto.inverst.OperateWithdrawExamPaperDto;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 问券用户答题试券记录
 * </p>
 *
 * @author zhangmin
 * @since 2023-03-22
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
@Accessors(chain = true)
public class OperateInverstWithdrawPaper extends IdEntity {

    /**
     * 小程序miniAppid
     */
    private String miniAppid;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 提现订单code
     */
    private String orderCode;

    /**
     * 答券编号
     */
    private String paperCode;

    /**
     * 答题人会员编号
     */
    private String userCode;

    /**
     * 答题人手机号
     */
    private String userMobile;

    /**
     * 答题人openId
     */
    private String userOpenid;


    /**
     * 姓名
     */
    private String userFullName;


    /**
     * 车牌号
     */
    private String carLicence;

    /**
     * 车架号
     */
    private String vinNo;


    /**
     * 题目数量
     */
    private Integer questNum;

    /**
     * 问券总分
     */
    private Integer totalRate;


    /**
     * 奖励金额，即提现到账金额，扣除手续费后的金额
     */
    private BigDecimal rewardAmt;


    /**
     * 问券答题提交试券时间
     */
    private LocalDateTime submitTime;

    /**
     * 状态:待同步/同步失败/同步成功
     * @see OperationConstant.DictWithdrawInverstPaperSyncStatus#PENDING
     */
    private String syncStatus;

    /**
     * 同步次数
     */
    private Integer syncCount;

    /**
     * 同步时间
     */
    private LocalDateTime syncTime;

    /**
     * 错误原因
     */
    private String errorDesc;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 问券答题详情json，对象是：examDbPaper
     */
    private String paperDetail;


    // ===== 以下是非持久化属性

    //要序列画到数据库中
    @TableField(exist = false)
    private OperateWithdrawExamPaperDbDto examDbPaper;


    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    @TableField(exist = false)
    private OperateWithdrawExamPaperDto examPaper;


}
