package com.rocogz.syy.operation.entity.label;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 运营标签表
 * </p>
 * @author 陈煜敏
 * @since 2023-02-15
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("operate_label")
public class OperateLabel extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 标签类型，4S店：4SD，裂变种子：FISSION_SEED
     * @see OperationConstant.OperateLabelType
     */
    private String type;

    /**
     * 标签编码
     */
    private String code;

    /**
     * 标签名称
     */
    private String name;

    /**
     * 标签说明
     */
    private String remark;

    /**
     * 登记人姓名
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 更新人姓名
     */
    @TableField(exist = false)
    private String updateUserName;

}
