package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 额度申请-审批附件表
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateQuotaApplyAttach extends IdEntity {

    /**
     * 申请单附件
     */
    public static final String QUOTA_APPLY_ATTACH = "QUOTA_APPLY";

    /**
     * 申请审批附件
     */
    public static final String QUOTA_APPLY_APPROVE_ATTACH = "QUOTA_APPROVE";

    /**
     * 申请编号
     */
    private String applyCode;

    /**
     * 申请单附件，审批附件, QUOTA_APPLY 或 QUOTA_APPROVE
     */
    private String attachType;

    /**
     * 审批记录Id编号（审批附件专有字段）
     * @see OperateQuotaApplyApproveRecord#id
     */
    private Integer approveRecordId;

    /**
     * 上传的文件名
     */
    private String uploadName;

    /**
     * 评价上传的图片附件
     */
    private String imgUrl;

    /**
     * 文档大小
     */
    private Integer fileSize;

    /**
     * 文件说明
     */
    private String description;

    /**
     * 图片顺序
     */
    private Integer seq;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
