package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 额度申请当前的审批流节点, 运行时流程实例节点
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
public class OperateQuotaApplyRuntimeNode extends BaseQuotaNode {

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 流程版本
     */
    private Integer version;

    /**
     * 下一个审批节点
     *
     * @see OperateQuotaDictNode#code
     */
    private String nextNodeCode;

    /**
     * 该节点是否审批完了，即是否走完了该流程
     */
    private Boolean approved;

    @TableField(exist = false)
    private List<OperateQuotaApplyRuntimeNodeApprover> runtimeApproverList;


    @JsonIgnoreProperties
    public List<String> getApproverUsernameList() {

        if (CollectionUtils.isEmpty(runtimeApproverList)) {
            return Collections.emptyList();

        }

        return runtimeApproverList.stream().map(OperateQuotaApplyRuntimeNodeApprover::getApproverUser)
                .distinct()
                .collect(Collectors.toList());
    }


}
