package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApplyNodeApproverTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 额度申请 当前启动流程运行实例 审批流节点的审批人信息
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateQuotaApplyRuntimeNodeApprover extends IdEntity {

    /**
     * 申请单号
     */
    private String applyCode;

    /**
     * 审批节点编号
     */
    private String nodeCode;

    /**
     * 节点业务类型：审核或审批
     */
    private QuotaApproveNodeTypeEnum nodeType;

    /**
     * 审批人用户名
     */
    private String approverUser;

    /**
     * 审批人名字
     */
    private String approverName;

    /**
     * 审批人手机号
     */
    private String approverMobile;

    /**
     * 审批人账号类型
     */
    private QuotaApplyNodeApproverTypeEnum approverType;

}
