package com.rocogz.syy.operation.entity.settle;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class Detail extends IdEntity {
    /**
     * 结算申请单
     */
    Integer settleId;

    /**
     * 结算申请单
     */
    String settleNo;

    /**
     * 供应商编码
     */
    String supplierCode;

    /**
     * 客户编码
     */
    String customerCode;

    /**
     * 发放单号
     */
    String applyNo;

    /**
     * 发放清单明细id
     */
    Integer applyId;

    /**
     * 发放单明细编码
     */
    String code;

    /**
     * 主体业务类型
     */
    String issuingBodyBusinessType;

    /**
     * 供应商产品编号
     */
    String platformProductCode;

    /**
     * ERP产品编号
     */
    String erpGoodsCode;

    /**
     * 客户产品编号
     */
    String customerProductCode;

    /**
     * 单位面值
     */
    BigDecimal unitFaceValue;

    /**
     * 市场价
     */
    BigDecimal marketPrice;

    /**
     * 成本价
     */
    BigDecimal costPrice;

    /**
     * 采购结算单价价
     */
    BigDecimal purchaseSettlePrice;

    /**
     * 发放数量
     */
    Integer quantity;

    /**
     * 结算金额
     */
    BigDecimal settleAmount;

    /**
     * 发放月份
     */
    String grantMonth;

    /**
     * 发放时间
     */
    LocalDateTime grantTime;

    /**
     * 发放人
     */
    String granter;

    /**
     * 领取时间
     */
    LocalDateTime receiveTime;

    /**
     * 发放单状态
     */
    String status;

    /**
     * 结算状态
     */
    String settleStatus;

    /**
     * 产品类别
     */
    String couponTypeCode;

    /**
     * 产品类型
     */
    String goodsType;
}
