package com.rocogz.syy.operation.entity.settle;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@TableName("settle_distribution_order")
public class SettleDistribution extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 结算申请单
     */
    private String settleDistributionNo;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商
     */
    @TableField(exist = false)
    private String supplierName;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户
     */
    @TableField(exist = false)
    private String customerName;


    /**
     * 结算单状态
     */
    private String status;

    /**
     * 结算金额
     */
    private BigDecimal settleAmount;

    /**
     * 实际结算金额
     */
    private BigDecimal realSettleAmount;

    /**
     * 对冲金额
     */
    private BigDecimal hedgingAmount;

    /**
     * 申请时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime applyTime;

    /**
     * 申请人
     */
    private String applyer;

    /**
     * 创建人名字
     */
    @TableField(exist = false)
    private String applyerName;

    /**
     * 审批时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime approveTime;

    /**
     * 审批人
     */
    private String approver;

    /**
     * 审批人名字
     */
    @TableField(exist = false)
    private String approverName;

    /**
     * 创建人名字
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 修改人名字
     */
    @TableField(exist = false)
    private String updateUserName;

    /**
     * 结算笔数
     */
    private Integer settleNum;

    /**
     * 对冲笔数
     */
    private Integer hedgingNum;

    /**
     * 结算总笔数
     */
    private Integer settleSum;

    /**
     * 到账时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
    private LocalDate receiveTime;

    /**
     * 清单查询开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime settleStartTime;

    /**
     * 清单查询结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime settleEndTime;

}
