package com.rocogz.syy.operation.enums;

import com.rocogz.syy.operation.constants.OperationConstant;
import lombok.Getter;

/**
 * 额度相关工作流类型
 * @author zhangmin
 */
@Getter
public enum QuotaWorkFlowTypeEnum {

    QUOTA_APPLY("额度申请工作流"),

    /**
     * 分额额度申请
     */
    ALLOCATE("划拨/收回额度工作流");

    private String label;

    QuotaWorkFlowTypeEnum(String label) {
        this.label = label;
    }

    public static QuotaWorkFlowTypeEnum valueOfTradeType(String tradeType) {

        if (OperationConstant.DictQuotaTradeType.QUOTA_APPLY.equalsIgnoreCase(tradeType)) {
            return QuotaWorkFlowTypeEnum.QUOTA_APPLY;
        }else {
            return QuotaWorkFlowTypeEnum.ALLOCATE;
        }
    }
}
