package com.rocogz.syy.operation.enums;

import lombok.Getter;

/**
 * @author liujianbing
 * 结算单状态
 */
@Getter
public enum SettleTypeEnum {

    DRAFT("DRAFT", "草稿",1),

    UN_AUDIT("UN_AUDIT","待审核",2), //提交动作

    NOT_APPROVED("NOT_APPROVED","不通过",99),  //审核不通过

    UN_PROCESS("UN_PROCESS","待处理",3), //审核通过待处理

    IN_PROCESS("IN_PROCESS","处理中",4), //确认结算，并输入到账日期

    SOLVED("SOLVED","已处理",99),

    VOIDED("VOIDED","已作废",99);

    private String code;

    private String label;

    private Integer seq;

    SettleTypeEnum(String code, String label, Integer seq) {
        this.code = code;
        this.label = label;
        this.seq = seq;
    }

    public static Integer getSeq(String code) {
        for (SettleTypeEnum values : values()) {
            if (values.getCode().equals(code)) {
                return values.getSeq();
            }
        }
        return null;
    }

    public static String getLabel(String code) {
        for (SettleTypeEnum values : values()) {
            if (values.getCode().equals(code)) {
                return values.getLabel();
            }
        }
        return null;
    }
}
