package com.rocogz.syy.operation.dto.car.dealer;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 交互动作记录查询dto
 * @date：2022/12/9
 * @author：huangdeyi
 */
@Data
public class InteractiveRecordSearchDto {

    /**
     * 编号
     */
    private String code;

    /**
     * 销售线索code
     */
    private String saleClewCode;

    /**
     * 4S店集团code
     */
    private String blocCode;

    /**
     * 4S店code
     */
    private String shopCode;

    /**
     * 交互年份
     */
    private String interactiveYear;

    /**
     * 交互月份
     */
    private String interactiveMonth;

    /**
     * 交互开始日期
     */
    private String interactiveStartDate;

    /**
     * 交互结束日期
     */
    private String interactiveEndDate;

    /**
     * 交互类型
     */
    private String interactiveType;

    /**
     * 交互主题
     */
    private String interactiveTopic;

    /**
     * 交互所属阶段
     */
    private String interactiveStage;

    /**
     * 交互登记人
     */
    private String createUsername;

    /**
     * 交互动作登记年
     */
    private String createYear;

    /**
     * 交互动作登记月
     */
    private List<String> createMonth;

    /**
     * 交互动作登记开始日期
     */
    private String createStartDate;

    /**
     * 交互动作登记结束日期
     */
    private String createEndDate;

    /**
     * 交互形式
     */
    private String interactiveWay;

    /**
     * 交互时业务上线情况
     */
    private String businessOnline;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;
}
