package com.rocogz.syy.operation.dto.inverst;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author zhangjunkui
 */
public final class WithdrawPaperUtils {


    /**
     * 根据提现积分,生成出题规则
     *
     * @param points
     * @return
     */
    public static List<InverstQuestionByRuleQueryReqRateItemDto> getQuestionRuleList(BigDecimal points, Map<Integer, Integer> questionQuantityMap) {
        //double类型分值，方便计算
        Double point = points.doubleValue();
        List<InverstQuestionByRuleQueryReqRateItemDto> ruleList = new ArrayList<>();

        //小于等于100分，全部给10分的题
        if (points.compareTo(new BigDecimal(100)) <= 0) {
            Double countDouble = (point / 10);
            int count = countDouble.intValue();
            if (point % 10 > 0) {
                count += 1;
            }
            InverstQuestionByRuleQueryReqRateItemDto rule = new InverstQuestionByRuleQueryReqRateItemDto();
            rule.setQuestRate(10);
            rule.setCount(count);
            ruleList.add(rule);
            return ruleList;
        }


        //第一遍计算出 每个分值 需要多少道题
        int tenCount = 0;

        //20分需要几道题
        int twentyCount = 0;

        //小于三百分，不出30分的题
        if (points.compareTo(new BigDecimal(300)) < 0) {
            //10分需要几道题
            Double tenCountDouble = point * 0.6 / 10;
            tenCount = tenCountDouble.intValue();
            //拿到 10分的题 一共有多少分
            Integer tenPoint = tenCount * 10;

            Double twentyCountDouble = point * 0.4 / 20;
            twentyCount = twentyCountDouble.intValue();
            Integer twentyPoint = twentyCount * 20;

            Double remainder = point - tenPoint - twentyPoint;

            if (remainder > 0) {
                if (remainder.intValue() / 20 > 0) {
                    Integer remainderCount = remainder.intValue() / 20;
                    int twentyRemainder = remainder.intValue() % 20;
                    twentyCount = twentyCount + remainderCount;
                    if (twentyRemainder > 10) {
                        twentyCount += 1;
                    } else if (twentyRemainder > 0) {
                        tenCount += 1;
                    }
                } else {
                    if (remainder > 10) {
                        twentyCount += 1;
                    } else {
                        tenCount += 1;
                    }
                }
            }

        } else {
            //10分需要几道题
            Double tenCountDouble = point * 0.3 / 10;
            tenCount = tenCountDouble.intValue();
            //拿到 10分的题 一共有多少分
            Integer tenPoint = tenCount * 10;

            Double twentyCountDouble = point * 0.3 / 20;
            twentyCount = twentyCountDouble.intValue();
            Integer twentyPoint = twentyCount * 20;

            //30分需要几道题
            Double thirtyCountDouble = point * 0.4 / 30;
            int thirtyCount = thirtyCountDouble.intValue();
            Integer thirtyPoint = thirtyCount * 30;

            Double remainder = point - tenPoint - twentyPoint - thirtyPoint;

            if (remainder > 0) {
                if (remainder.intValue() / 30 > 0) {
                    int remainderCount = remainder.intValue() / 30;
                    thirtyCount = thirtyCount + remainderCount;
                    Double thirtyRemainder = remainder - remainderCount * 30;
                    if (thirtyRemainder > 20) {
                        thirtyCount = thirtyCount + 1;
                    } else if (thirtyRemainder > 10) {
                        twentyCount += 1;
                    } else if (thirtyRemainder > 0) {
                        tenCount += 1;
                    }
                } else if (remainder.intValue() / 20 > 0) {
                    if (remainder == 20) {
                        twentyCount += 1;
                    } else {
                        thirtyCount = thirtyCount + 1;
                    }
                } else if (remainder.intValue() / 10 > 0) {
                    if (remainder == 10) {
                        tenCount += 1;
                    } else {
                        twentyCount += 1;
                    }
                } else {
                    tenCount += 1;
                }
            }
            InverstQuestionByRuleQueryReqRateItemDto thirtyRule = new InverstQuestionByRuleQueryReqRateItemDto();
            thirtyRule.setQuestRate(30);
            //题库中30分的题有多少
            Integer thirtyQuestion = questionQuantityMap.get(30);
            if (Objects.nonNull(thirtyQuestion)) {
                if (thirtyCount > thirtyQuestion) {
                    int thirtyUnnecessary = thirtyCount - thirtyQuestion;
                    int pointUnnce = thirtyUnnecessary * 30;
                    int addTwentyCount = pointUnnce / 20;
                    twentyCount += addTwentyCount;
                    if (pointUnnce - addTwentyCount * 20 > 0) {
                        tenCount += 1;
                    }
                    thirtyCount = thirtyQuestion;
                }
            }
            thirtyRule.setCount(thirtyCount);
            ruleList.add(thirtyRule);
        }
        InverstQuestionByRuleQueryReqRateItemDto twentyRule = new InverstQuestionByRuleQueryReqRateItemDto();
        twentyRule.setQuestRate(20);
        Integer twentyQuestion = questionQuantityMap.get(20);
        if (Objects.nonNull(twentyQuestion)) {
            if (twentyCount > twentyQuestion) {
                int twentyUnnecessary = twentyCount - twentyQuestion;
                int pointUnnce = twentyUnnecessary * 20;
                int addTenCount = pointUnnce / 10;
                tenCount += addTenCount;
                twentyCount = twentyQuestion;
            }
        }
        twentyRule.setCount(twentyCount);
        InverstQuestionByRuleQueryReqRateItemDto tenRule = new InverstQuestionByRuleQueryReqRateItemDto();
        tenRule.setQuestRate(10);
        tenRule.setCount(tenCount);
        ruleList.add(tenRule);
        ruleList.add(twentyRule);
        return ruleList;
    }


    //勾选中用户的答案
    public static void checkUserAnswer(OperateWithdrawExamPaperDto examPaper, OperateWithdrawExamPaperDbDto dbPaperDto) {

        //用户答题选项： Map<String,checked>
        Map<String, Boolean> userCheckedMap = new HashMap<>();


        for (OperateWithdrawQuestDbDto dbQt : dbPaperDto.getQuestList()) {

            for (OperateWithdrawQuestOptionDbDto dbOpt : dbQt.getOptionList()) {
                userCheckedMap.put(dbOpt.getOptCode(), dbOpt.getChecked());
            }
        }

        for (OperateWithdrawQuestDto renderQuest : examPaper.getQuestList()) {

            for (OperateWithdrawQuestOptionDto renderOpt : renderQuest.getOptionList()) {
                renderOpt.setChecked(userCheckedMap.get(renderOpt.getOptCode()));

            }
        }

    }

}
