package com.rocogz.syy.operation.dto.quotapply;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.CoverDepositTypeEnum;
import com.rocogz.syy.operation.enums.QuotaApplyAffairTabEnum;
import com.rocogz.syy.operation.enums.QuotaApplyModeEnum;
import com.rocogz.syy.operation.enums.QuotaManageModeEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 管理端小程序，填写额度申请：第一步，搜索 当前登录申请人 能申请的主体
 *
 * @author zhangmin
 */
@Setter
@Getter
public class SearchCanApplyIssueBodyParamDto {


    /**
     * 搜索字段：主体业内名字，主体规范名称
     */
    private String keyword;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;


    /**
     * 申请人用户名，登录的用户名
     */
    private String applierUser;


    private Integer limit = 20;

    private Integer page = 1;

    public String getKeywordLike() {
        return StringUtils.isBlank(keyword) ? null : "%" + keyword + "%";
    }
}
