package com.rocogz.syy.operation.dto.quotapply;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * B端小程序端 按照状态分组统计额度申请单个数/金额
 *
 * @author zhangmin
 */
@Setter
@Getter
public class WapStatisQuotaApplyGroupByStatusParamDto {

    /**
     * 申请人用户名
     */
    private String applierUser;

    /**
     * 用户选中的发放主体过滤条件
     */
    private String selectedIssuingBodyCode;

    /**
     * 服务商编号列表【数据权限中服务商编号】
     */
    private List<String> agentCodeList;

    /**
     * 发放主体编号列表 【数据权限中发放主体编号】
     */
    private List<String> issuingBodyCodeList;


    /**
     * 合作客户的 【数据权限中客户编号】
     */
    private List<String> customerCodeList;


    /**
     * B端统计 要排除的状态（草稿状态和作废状态 要排除）
     */
    private List<String> excludeStatusList;


    /**
     * 额度申请的交易类型
     *
     * @see OperationConstant.DictQuotaTradeType#QUOTA_APPLY
     */
    private String tradeType;

    /**
     * 额度费用类型
     *
     * @see OperationConstant.DictQuotaApplyFeeType#UNIVERSAL_USE
     */
    private String feeType;

    /**
     * 申请人名称关键词  模糊匹配
     */
    private String keyword;

    /**
     * keyword关键词 在equity_issuing_body 主体简称 中 匹配出来的主体编号列表
     */
    private List<String> keywordBodyCodeList;

    /**
     * 额度申请的 额度调整类型【交易类型是额度申请】
     *
     * @see OperationConstant.DictQuotaAdjustType#ADD
     */
    private String adjustType;

    private String startTime;

    private String endTime;


    public String getKeywordLike() {
        keyword = StringUtils.trimAllWhitespace(keyword);

        if (StringUtils.isEmpty(keyword)) {
            return null;
        }
        return "%" + keyword + "%";
    }

}
