package com.rocogz.syy.operation.entity.quotapply;

import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApplyModeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 额度申请配置的申请人
 * </p>
 *
 * @author zhangmin
 * @since 2023-02-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OperateQuotaConfigApplier extends IdEntity {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 额度申请人用户名
     */
    private String applierUser;

    /**
     * 额度申请人名字
     */
    private String applierName;

    /**
     * 申请人手机号
     */
    private String applierMobile;

    /**
     * 额度申请模式:运营代申请、主体自己申请
     */
    private QuotaApplyModeEnum applyMode;

    /**
     * 申请人 能用的费用类型,多个费用类型用逗号分开，费用类型数据来源于发放主体【只有主体自己申请需要配置】
     * 如果是 运营代申请，则不需要配置此值，取发放主体上配置的费用类型
     */
    private String feeTypes;


    /**
     * 申请人账号 所属主体编号（主体自己申请 专有字段）
     */
    private String belongBodyCode;

    /**
     * 添加时间
     */
    private LocalDateTime createTime;

    /**
     * 添加人
     */
    private String createUser;


    /**
     * 申请人账号 所属主体名字，非PO字段
     */
    private transient String belongBodyName;

    /**
     * 添加人名字
     */
    private transient String createUserFullName;

    //多个用逗号分割
    private transient String feeTypeNames;

}
