package com.rocogz.syy.operation.entity.settle;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
@TableName("settle_distribution_log")
public class SettleDistributionLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 结算单号
     */
    private String settleNo;

    /**
     * 操作项
     */
    private String operateAction;

    /**
     * 操作前状态
     */
    private String operateBeforeStatus;

    /**
     * 操作后状态
     */
    private String operateAfterStatus;

    /**
     * 说明
     */
    private String commente;

    /**
     * 操作人账户名
     */
    private String operationUsername;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime operationTime;

}
