package com.rocogz.syy.operation.enums;

import lombok.Getter;

/**
 * 额度管理模式
 * @author zhangmin
 */
@Getter
public enum QuotaManageModeEnum {

    /**
     * 申请的入口包括：
     * （1）B端小程序,B端小程序的申请只能是 虚拟额度管理（VIRTUAL_MODE）, 申请模式只能是：ISSUING_BODY_SELF("主体自己申请")
     * （2）管理端小程序,  可选申请模式：OPERATOR_PROXY("运营代申请") 或  ISSUING_BODY_SELF("主体自己申请")
     *  (3)admin端申请,  可选申请模式： OPERATOR_PROXY("运营代申请") 或  ISSUING_BODY_SELF("主体自己申请")
     */
    VIRTUAL_MODE("虚拟额度管理"),

    /**
     * 备付金管理的申请模式 只能运营代申请，登录的是系统账号，  备付金管理：额度申请模式自动选中【运营代申请】，不可修改
     * 申请入口如下：
     * （1）管理端小程序
     * （2）admin端申请
     * （3）备付金管理 只能是 运营代申请，不能主体自己申请
     * 备付金：又分2种：收款充值, 借款授信
     */
    RESERVE_PAYMENT("备付金管理");   // 可选申请模式仅：OPERATOR_PROXY("运营代申请")

    private String label;

    QuotaManageModeEnum(String label) {
        this.label = label;
    }
}
