package com.rocogz.syy.operation.wx.dto;

import lombok.*;

import java.io.Serializable;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OperationWxMaTemplateMessage implements Serializable {

    private static final long serialVersionUID = 5063374783759519418L;

    /**日志信息，用于打印的*/
    private String logInfo;

    /**
     * 用户openid.
     * 可以是小程序的openid，也可以是mp_template_msg.appid对应的公众号的openid
     */
    private String toUser;

    /**
     * 公众号appid，要求与小程序有绑定且同主体.
     */
    private String appid;

    /**
     * 公众号或小程序模板ID.
     */
    private String templateId;

    /**
     * 公众号模板消息所要跳转的url.
     */
    private String url;

    /**
     * 公众号模板消息所要跳转的小程序，小程序的必须与公众号具有绑定关系.
     */
    private MiniProgram miniProgram;

    /**
     * 小程序模板数据.
     */
    private List<OperationWxMpTemplateData> data;


    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MiniProgram implements Serializable {
        private static final long serialVersionUID = -7945254706501974849L;

        private String appid;
        private String pagePath;

        /**
         * 是否使用path，否则使用pagepath.
         * 加入此字段是基于微信官方接口变化多端的考虑
         */
        private boolean usePath = false;


    }

}
