package com.rocogz.syy.operation.dto.quotapply;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocogz.syy.operation.constants.OperationConstant;
import com.rocogz.syy.operation.enums.QuotaApplyQueryDataRangeEnum;
import com.rocogz.syy.operation.enums.QuotaApplyQueryTaskTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * admin端搜索 额度申请单 查询参数
 *
 * @author zhangmin
 */
@Setter
@Getter
public class AdminSearchQuotaApplyParamDto extends BaseSearchQuotaApplyDto {

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;

    /**
     * 数据范围，如果是管理员账号,数据范围是ALL, 其它账号数据范围是 RELATE_ME
     */
    private QuotaApplyQueryDataRangeEnum dataRange = QuotaApplyQueryDataRangeEnum.ALL;

    private QuotaApplyQueryTaskTypeEnum taskType = QuotaApplyQueryTaskTypeEnum.ABOUT_ME;

    /**
     * admin端登录的用户名,可能是申请人或审批人的用户名
     */
    private String loginUserName;


    /**
     * 申请单号：【精确匹配】
     */
    private String applyCode;


    /**
     * 申请人名字:[模糊匹配]
     */
    private String applierName;

    /**
     * 申请人手机:[精确匹配]
     */
    private String applierMobile;

    /**
     * 查询的发放主体账号列表
     */
    private List<String> issuingBodyCodeList;

    /**
     * 申请方式:整体或分团队
     *
     * @see OperationConstant.DictQuotaApplyWay
     */
    private String applyWay;

    /**
     * 申请开始日期
     */
    private String startDate;

    /**
     * 申请结束日期
     */
    private String endDate;


    @JsonIgnore
    public String getLikeApplierName() {
        if (StringUtils.isBlank(applierName)) {
            return null;
        }
        return "%" + applierName + "%";
    }


    public String getStartDate() {
        if (StringUtils.isBlank(startDate)) {
            return null;
        }

        return startDate + OperationConstant.MAX_TIME_SUFFIX;
    }


    public String getEndDate() {
        if (StringUtils.isBlank(endDate)) {
            return null;
        }

        return endDate + OperationConstant.MAX_TIME_SUFFIX;
    }


}
