package com.rocogz.syy.operation.entity.filter;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 运营服务-筛选条件组标签表
 * </p>
 *
 * @author luoyc
 * @since 2021-01-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("operate_filter_label")
public class OperateFilterLabel extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 条件组id
     */
    private Integer filterGroupId;

    /**
     * 排序号
     */
    private Integer sort = 0;

    /**
     * 关联的商户标签code
     */
    private String filterLabelCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新人
     */
    private String updateUser;

    @TableField(exist = false)
    private String name;

    @TableField(exist = false)
    private String labelIcon;

    @TableField(exist = false)
    private String description;

    @TableField(exist = false)
    private List<String> filterLabelCodes;

}
