package com.rocogz.syy.operation.entity.quotapply;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 额度申请 基础审批流节点,包括系统平台节点，代理商审批节点
 * </p>
 *
 * @author zhangmin
 * @since 2021-07-06
 */
@Setter @Getter
@Accessors(chain = true)
public class OperateQuotaBaseConfigNode extends BaseQuotaNode {

    /**
     * 代理商编号（代理商审批账号专有）
     */
    private String agentCode;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
