package com.rocogz.syy.operation.entity.quotapply;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.operation.enums.QuotaApproveNodeTypeEnum;
import jdk.nashorn.internal.runtime.regexp.joni.ast.QuantifierNode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 发放主体 额度申请审批流设置,流程定义
 * </p>
 *
 * @author zhangmin
 * @since 2021-06-23
 */
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OperateQuotaIssuingConfigNode extends BaseQuotaNode {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 流程定义版本
     */
    private Integer version;

    private String createUser;

    private LocalDateTime createTime;

    private String updateUser;

    private LocalDateTime updateTime;

}
