package com.rocogz.syy.operation.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 保险佣点操作日志表
 *
 * @author luoyc
 * @since 2020-08-26
 */
@Data
@Accessors(chain = true)
@TableName("operate_insurance_commission_log")
public class OperateInsuranceCommissionLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 保险佣点编码
     */
    private String oicCode;

    /**
     * 保险公司代码
     */
    private String companyCode;

    /**
     * 操作类型
     */
    private String operate;

    /**
     * 操作信息
     */
    private String operateMessage;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;

}
