package com.rocogz.syy.settlement.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.settlement.entity.SettleSubject;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 结算中心对外feign接口 service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-30 上午 7:18</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
public interface ISettlementClientService {

    //  =========  start of 结算主体 模块   ===========

    /**
     * 结算主体管理-结算主体列表
     * @param code
     * @param name
     * @param type
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/settle/subject")
    PageTable<SettleSubject> searchSettleSubject(@RequestParam(name = "code",required = false) String code,
                                          @RequestParam(name = "name",required = false) String name,
                                          @RequestParam(name = "type",required = false) String type,
                                          @RequestParam(name = "status",required = false) String status,
                                          @RequestParam(name = "limit",defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page",defaultValue = "1") Integer page);




    /**
     * 结算主体管理-更新结算主体的状态
     * @param settleSubject
     * @return
     */
    @PostMapping("/api/settle/subject/switchSettleSubjectStatus")
    Response switchSettleSubjectStatus(@RequestBody SettleSubject settleSubject);

    /**
     * 结算主体管理-根据id删除
     *
     * @param id
     * @return
     */
    @PostMapping("/api/settle/subject/deleteSettleSubject")
    Response deleteSettleSubject(@RequestParam(name = "id") Integer id);

    /**
     * 新增和更新结算主体
     *
     * @param settleSubject
     * @return
     */
    @PostMapping("/api/settle/subject/createOrUpdateSettleSubject")
    Response createOrUpdateSettleSubject(@RequestBody SettleSubject settleSubject);


    /**
     * 结算主体管理-根据id查询结算主体
     *
     * @param id
     * @return
     */
    @GetMapping("/api/settle/subject/{id}")
    Response<SettleSubject> getSettleSubjectById(@PathVariable("id") Integer id);

    /**
     * 结算主体管理-根据code查询结算主体
     *
     * @param code
     * @return
     */
    @GetMapping("/api/settle/subject/{code}")
    Response<SettleSubject> getSettleSubjectByCode(@PathVariable("code") String code);


    /**
     * 版块管理-新增获取主体code
     * @return
     */
    @GetMapping("/api/settle/subject/getSettleSubjectCode")
     Response<String> getSettleSubjectCode();


    /**
     * 结算主体管理-查找主体类型下的name是否存在
     * @param type
     * @param name
     * @return
     */
    @PostMapping("/api/settle/subject/getCheckName")
    List<SettleSubject> getCheckName(@RequestParam(name = "code") String code,@RequestParam(name = "type") String type,@RequestParam(name = "name") String name);

    // =========  end of  结算主体 模块   ===========
}
