package com.rocogz.syy.settlement.constant;

/**
 * <dl>
 * <dd>Description: 结算中心基础服务，常量类 service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-30 上午 7:44</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
public class SettlementConstant {
    /**
     * 结算中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "settlement-service";

    /**
     * like查询通配符
     */
    public static final String LIKE_WILD_CARD = "%";

    /**
     * 自动发放的 操作人名字
     */
    public static final String SYSTEM_CREATE_NAME = "系统";

    /**
     * 账户校验Redis锁前缀
     */
    public static final String ACCT_TRADE_LOCK_KEY="acct:trade:lock:";

    /**
     * 电子账户余额Redis Key前缀
     */
    public static final String ELECTRONIC_ACCT_BALANCE_KEY_PREFIX = "ELE_ACCT_BALANCE:";

    /**
     * 电子账户余额更新Redis锁的Key前缀
     */
    public static final String ELECTRONIC_ACCT_BALANCE_UPDATE_KEY_PREFIX = "ELE_ACCT_BALANCE_UPDATE:";

    /**
     * 电子账户订单扣减Redis锁前缀
     */
    public static final String ELECTRONIC_ACCT_UPDATE_LOCK_KEY_PREFIX = "ELE_ACCT_TRADE:";

    /**
     * 启用/停用状态
     */
    public static class DictSwitchStatus {
        //字典类型编号
        public static final String TYPE_CODE = "COMMON_STATUS";

        //=== 下面是字典值

        //启用
        public static final String OPEN = "OPEN";

        //停用
        public static final String LOCK = "LOCK";

    }



    /**
     * 个人账户 扣减模式
     */
    public static class DictDeductPattern {
        //字典类型编号
        public static final String TYPE_CODE = "DEDUCTION_PATTERN";


        //=== 下面是字典值

        //扣除个人账户 余额
        public static final String DEDUCT_PERSONAL_BALANCE = "DEDUCT_PERSONAL_BALANCE";

        //扣减【发放主体账户】额度
        public static final String DEDUCT_ISSUE_BODY = "DEDUCT_ISSUE_BODY";

        //扣减【团队账户】额度
        public static final String DEDUCT_TEAM = "DEDUCT_TEAM";

    }

    /**
     * 调整记录类型
     */
    public static class  AccountAdjustType{

        public static final String TYPE_CODE = "account_adjust_type";

        /**
         * 增加
         */
        public static final String ADD = "ADD";

        /**
         * 减少
         */
        public static final String REDUCE = "REDUCE";

        /**
         * 划拨额度-划出
         */
        public static final String ALLOCATE_OUT = "ALLOCATE_OUT";

        /**
         * 划拨额度-划入
         */
        public static final String ALLOCATE_IN = "ALLOCATE_IN";

        /**
         * 收回额度-划出
         */
        public static final String ALLOCATE_BACK_OUT = "ALLOCATE_BACK_OUT";

        /**
         * 收回额度-划入
         */
        public static final String ALLOCATE_BACK_IN = "ALLOCATE_BACK_IN";

        /**
         * 自动划拨额度-划出
         */
        public static final String AUTO_ALLOCATE_OUT = "AUTO_ALLOCATE_OUT";

        /**
         * 自动划拨额度-划入
         */
        public static final String AUTO_ALLOCATE_IN = "AUTO_ALLOCATE_IN";

        /**
         * 自动收回额度-划出
         */
        public static final String AUTO_ALLOCATE_BACK_OUT = "AUTO_ALLOCATE_BACK_OUT";

        /**
         * 自动收回额度-划入
         */
        public static final String AUTO_ALLOCATE_BACK_IN = "AUTO_ALLOCATE_BACK_IN";

        /**
         * 上级划拨额度-划出
         */
        public static final String P_ALLOCATE_OUT = "P_ALLOCATE_OUT";

        /**
         * 上级划拨额度-划入
         */
        public static final String P_ALLOCATE_IN = "P_ALLOCATE_IN";

        /**
         * 上级收回额度-划出
         */
        public static final String P_ALLOCATE_BACK_OUT = "P_ALLOCATE_BACK_OUT";

        /**
         * 上级收回额度-划入
         */
        public static final String P_ALLOCATE_BACK_IN = "P_ALLOCATE_BACK_IN";

    }



    /**
     * 账户类型
     */
    public static class DictAccountType {

        public static final String TYPE_CODE = "account_type";

        //发放主体账户
        public static final String ISSUING_BODY = "ISSUING_BODY";

        //团队账户
        public static final String TEAM = "TEAM";

        //个人账户
        public static final String PERSON = "PERSON";

    }


    /**
     * 手工调额类型
     */
    public static class ManualQuotaTypeDictData {
        //字典类型编号
            public static final String TYPE_CODE = "ELECTRONIC_ACCT_MANUAL_TYPE";

        //=== 下面是字典值
        //手工增加
        public static final String ELECTRONIC_ACCT_MANUAL_TYPE_INCREASE = "INCREASE";

        //手工减少
        public static final String ELECTRONIC_ACCT_MANUAL_TYPE_REDUCE = "REDUCE";
    }


    /**
     * 额度扣减时点字典数据
     */
    public static class DeductionTimeAppointDictData {
        //字典类型编号
        public static final String TYPE_CODE = "DEDUCTION_TIME_APPOINT";

        //=== 下面是字典值
        //发放时扣减
        public static final String DEDUCTION_ON_ISSUE = "DEDUCTION_ON_ISSUE";

        //领取时扣减
        public static final String DEDUCTION_ON_COLLECTION = "DEDUCTION_ON_COLLECTION";
    }

    /**
     * 电子账户关联类型字典值
     */
        public static class ElectronicAccountLinkType {
        //字典类型编号
        public static final String TYPE_CODE = "ELECTRONIC_ACCT_LINK_TYPE";

        //代理商
        public static final String AGENT = "AGENT";

        //合作客户
        public static final String CUSTOMER = "CUSTOMER";
    }

    /**
     * 电子账户额度管理模式字典值
     */
    public static class ElectronicAccountQuotaMode {
        //字典类型编号
        public static final String TYPE_CODE = "ELECTRONIC_ACCT_QUOTA_MODE";

        //虚拟额度
        public static final String VIRTUAL_MODE = "VIRTUAL_MODE";

        //备付金
        public static final String RESERVE_PAYMENT = "RESERVE_PAYMENT";
    }

    /**
     * 电子账户操作类型-字典值
     */
    public static class ElectronicAccountOperateType {
        //字典类型编号
        public static final String TYPE_CODE = "ELECTRONIC_ACCT_OPERATE_TYPE";

        //虚拟额度-充值
        public static final String VIRTUAL_QUOTA_RECHARGE = "VIRTUAL_QUOTA_RECHARGE";

        //虚拟额度-扣减
        public static final String VIRTUAL_QUOTA_DEDUCTION = "VIRTUAL_QUOTA_DEDUCTION";

        //备付金-充值
        public static final String RESERVE_PAYMENT_RECHARGE = "RESERVE_PAYMENT_RECHARGE";

        // 订单支付-扣减额度
        public static final String ORDER_PAY = "ORDER_PAY";

        // 订单退款-增加额度
        public static final String ORDER_REFUND = "ORDER_REFUND";
    }

    /**
     * 电子账户流水类型-字典值
     */
    public static class ElectronicAccountFlowTransactionType {
        //字典类型编号
        public static final String TYPE_CODE = "ELECTRONIC_ACCT_FLOW_TYPE";

        // 支付扣款(接口)
        public static final String PAY = "PAY";

        // 支付退款(接口)
        public static final String REFUND = "REFUND";

        // 手工充值(后台)
        public static final String RECHARGE = "RECHARGE";

        // 手工减少额度(后台)
        public static final String DEDUCTION = "DEDUCTION";
    }



    public static class Loglabel {
        /**
         * 日志操作类型-创建
         */
        public static final  String LOG_ADD_LABEL = "创建";
        /**
         * 日志操作类型-创建
         */
        public static final  String LOG_EDIT_LABEL = "编辑";

    }

}
