package com.rocogz.syy.settlement.dto;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.Pattern;

/**
 * 【搜索个人账户列表】dto 管理-主体账号专用
 * @author zhangmin
 * @date 2020/6/15
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class AdminSearchPersonalAccountDto extends AdminSearchPersonalBaseDto {

    /**
     * 发放主体账户编号【登录账号的发放主体账户】
     */
    private String issuingBodyAcctCode;

    /**
     * 发放主体名称【导出个人账户列表Excel 文件名使用】
     */
    private String issuingBodyName;

    /**
     * 个人账户编号【精确匹配】
     */
    private String personAcctNo;

    /**
     * 个人名字【模糊匹配】
     */
    private String personName;

    /**
     * 个人手机号【模糊匹配】
     */
    private String personMobile;

    /**
     * 账户 启用状态
     * @see SettlementConstant.DictSwitchStatus
     */
    private String status;


    /**
     * 额度扣减模式
     * @see SettlementConstant.DictDeductPattern
     */
    private String deductPattern;


    /**
     * 是否归属团队
     */
    private Boolean joinTeam;


    @JsonIgnore
    public String getPersonNameLike() {
        if(StringUtils.isBlank(personName)) {
            return null;
        }

        return SettlementConstant.LIKE_WILD_CARD + personName.trim() + SettlementConstant.LIKE_WILD_CARD;
    }


    @JsonIgnore
    public String getPersonMobileLike() {
        if(StringUtils.isBlank(personMobile)) {
            return null;
        }

        return SettlementConstant.LIKE_WILD_CARD + personMobile.trim() + SettlementConstant.LIKE_WILD_CARD;
    }

}
