package com.rocogz.syy.settlement.entity.account;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:账户额度调整记录（不包括发放） </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2021/4/8 14:42</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleAccountAdjustRecord extends IdEntity {

    /**
     * 调整记录编号
     */
    private String adjustRecordNo;

    /**
     * 记录归属账户编号
     */
    private String acctNo;

    /**
     * 业务编号(自动划拨或者收回有)
     */
    private String businessNo;

    /**
     * 记录归属账户类型
     * @see SettlementConstant.DictAccountType
     */
    private String acctType;

    /**
     * 目标账户编号(划出、自动划出操作有值)
     */
    private String toAcctNo;

    /**
     * 目标账户类型(划出、自动划出操作有值)
     * @see SettlementConstant.DictAccountType
     */
    private String toAcctType;

    /**
     * 来源账户编号（划入、自动划入操作有值）
     */
    private String fromAcctNo;

    /**
     * 来源账户类型（划入、自动划入操作有值）
     * @see SettlementConstant.DictAccountType
     */
    private String fromAcctType;

    /**
     * 调整额度
     */
    private BigDecimal allocateAmount;

    /**
     * 调整类型
     * @see SettlementConstant.AccountAdjustType
     */
    private String allocateType;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作人名字
     */
    @TableField(exist = false)
    private String createUserName;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作日期,即划拨日期
     */
    private LocalDate createDate;

    //账户对应的账号信息
    @TableField(exist = false)
    private SettleAccountInfo  accountInfo;

}