package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_quota_manual")
public class SettleElectronicAccountQuotaManual extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务单号
     */
    private String code;

    /**
     * 电子账户code
     */
    private String acctCode;

    /**
     * 调整类型：INCREASE:增加,  REDUCE:减少
     */
    private String type;

    /**
     * 变化额度
     */
    private BigDecimal quota;

    /**
     * 调整凭证
     */
    private String voucherImg;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private String createUser;

    @TableField(exist = false)
    private String linkCode;

    /**
     * 调整类型-名称
     */
    @TableField(exist = false)
    private String typeName;
}
