package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_quota_provision")
public class SettleElectronicAccountQuotaProvision extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 业务单号
     */
    private String code;

    /**
     * 电子账户code
     */
    private String acctCode;

    /**
     * 额度
     */
    private BigDecimal quota;

    /**
     * 付款日期
     */
    private LocalDate payDate;

    /**
     * 收款日期
     */
    private LocalDate collectDate;

    /**
     * 付款凭证
     */
    private String payVoucherImg;

    /**
     * 收款凭证
     */
    private String collectVoucherImg;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private String createUser;

    @TableField(exist = false)
    private String linkCode;


    @TableField(exist = false)
    private String linkName;


    @TableField(exist = false)
    private String linkType;
}
