package com.rocogz.syy.settlement.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.settlement.dto.*;
import com.rocogz.syy.settlement.entity.SettleSubject;
import com.rocogz.syy.settlement.entity.account.SettleAccount;
import com.rocogz.syy.settlement.entity.account.SettleAccountAdjustRecord;
import com.rocogz.syy.settlement.entity.account.SettleAccountInfo;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 结算中心对外feign接口 service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-30 上午 7:18</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
public interface ISettlementClientService {

    //  =========  start of 结算主体 模块   ===========

    /**
     * 结算主体管理-结算主体列表
     * @param code
     * @param name
     * @param type
     * @param limit
     * @param page
     * @return
     */
    @GetMapping("/api/settle/subject")
    PageTable<SettleSubject> searchSettleSubject(@RequestParam(name = "code",required = false) String code,
                                          @RequestParam(name = "name",required = false) String name,
                                          @RequestParam(name = "settleSubjectList",required = false) List<String> settleSubjectList,
                                          @RequestParam(name = "type",required = false) String type,
                                          @RequestParam(name = "status",required = false) String status,
                                          @RequestParam(name = "limit",defaultValue = "20") Integer limit,
                                          @RequestParam(name = "page",defaultValue = "1") Integer page);




    /**
     * 结算主体管理-更新结算主体的状态
     * @param settleSubject
     * @return
     */
    @PostMapping("/api/settle/subject/switchSettleSubjectStatus")
    Response switchSettleSubjectStatus(@RequestBody SettleSubject settleSubject);

    /**
     * 结算主体管理-根据id删除
     *
     * @param id
     * @return
     */
    @PostMapping("/api/settle/subject/deleteSettleSubject")
    Response deleteSettleSubject(@RequestParam(name = "id") Integer id);

    /**
     * 新增和更新结算主体
     *
     * @param settleSubject
     * @return
     */
    @PostMapping("/api/settle/subject/createOrUpdateSettleSubject")
    Response createOrUpdateSettleSubject(@RequestBody SettleSubject settleSubject);


    /**
     * 结算主体管理-根据id查询结算主体
     *
     * @param id
     * @return
     */
    @GetMapping("/api/settle/subject/detail/{id}")
    Response<SettleSubject> getSettleSubjectById(@PathVariable("id") Integer id);

    /**
     * 结算主体管理-根据code查询结算主体
     *
     * @param code
     * @return
     */
    @GetMapping("/api/settle/subject/{code}")
    Response<SettleSubject> getSettleSubjectByCode(@PathVariable("code") String code);


    /**
     * 版块管理-新增获取主体code
     * @return
     */
    @GetMapping("/api/settle/subject/getSettleSubjectCode")
     Response<String> getSettleSubjectCode();


    /**
     * 结算主体管理-查找主体类型下的name是否存在
     * @param type
     * @param name
     * @return
     */
    @PostMapping("/api/settle/subject/getCheckName")
    List<SettleSubject> getCheckName(@RequestParam(name = "code") String code,@RequestParam(name = "type") String type,@RequestParam(name = "name") String name);

    /**
     * yinshihao 数据权限管理时，需要获取无分页结算主体信息,只有code和name
     */
    @GetMapping("/api/settle/subject/settleSubjectList")
    Response<List<SettleSubject>> settleSubjectList();
    // =========  end of  结算主体 模块   ===========

    //  =========  start of 账户 模块   ===========
    /**
     * 发放主体分页查询
     *
     * @param accountResDto
     * @return
     */
    @PostMapping("/api/settle/account/queryPage")
    PageTable<SettleAccount> accountPageTable(@RequestBody AccountResDTO accountResDto);

    /**
     * 发放主体列表查询
     *
     * @param accountResDto
     * @return
     */
    @PostMapping("/api/settle/account/findAccountList")
    Response<List<SettleAccount>> findAccountList(@RequestBody AccountResDTO accountResDto);

    /**
     * 保存账户
     *
     * @param addAccountResDTO
     * @return
     */
    @PostMapping("/api/settle/account/saveSettleAccount")
    Response<SettleAccount> saveSettleAccount(@RequestBody AddAccountResDTO addAccountResDTO);

    /**
     * 设置发放主体账户额度扣减时点
     *
     * @param acctNos
     * @param deductionTimeAppoint
     * @param updateUser
     * @return
     */
    @GetMapping("/api/settle/account/editDeductionTimeAppoint")
    Response editDeductionTimeAppoint(@RequestParam("acctNos") List<String> acctNos,
                                      @RequestParam("deductionTimeAppoint") String deductionTimeAppoint,
                                      @RequestParam("updateUser") String updateUser);

    /**
     * 操作发放主体账户状态
     * @param accountStatusDTO
     * @return
     */
    @PostMapping("/api/settle/account/operateStatus")
    Response operateStatus(@RequestBody OperationAccountStatusDTO accountStatusDTO);

    /**
     * 调整发放主体账户额度
     * @param operationAccountAmountDTO
     * @return
     */
    @PostMapping("/api/settle/account/operationAccountAmount")
    Response operationAccountAmount(@RequestBody OperationAccountAmountDTO operationAccountAmountDTO);

    /**
     * 根据账户编号查询账户信息,包括账户关联信息
     * @param acctNo
     * @return
     */
    @GetMapping("/api/settle/account/getAllInfoByAccNo")
    Response<SettleAccount> getAllInfoByAccNo(@RequestParam("acctNo") String acctNo);

    /**
     * 发放主体账户额度划拨记录分页查询
     *
     * @param accountResDto
     * @return
     */
    @PostMapping("/api/settle/account/accountOperationLogPageTable")
    PageTable<SettleAccountAdjustRecord> accountOperationLogPageTable(@RequestBody AccountOperationLogResDTO accountResDto);

    /**
     * 根据账户编号列表查询账户信息
     * @param acctNos
     * @return
     */
    @GetMapping("/api/settle/account/findByAccNos")
    Response<List<SettleAccount>> findByAccNos(@RequestParam("acctNos") List<String> acctNos);

    // =========  end of  账户 模块   ===========




    //  =========  start of 个人账户 模块   ===========


    /**
     * 获取个人账户，以及关联的账户信息
     * @param userName 登录的主体账号对应的用户名
     */
    @GetMapping("/api/settle/personalAccount/info/getPersonalAccountProfile")
    Response<AccountProfileDto> getPersonalAccountProfile(@RequestParam("userName") String userName);

    /**
     * 获取账户编号获取个人账户，以及关联的账户信息
     *
     * @param userName 登录的主体账号对应的用户名
     */
    @GetMapping("/api/settle/personalAccount/info/getPersonalAccountProfileByAcctNo")
    Response<AccountProfileDto> getPersonalAccountProfileByAcctNo(@RequestParam("acctNo") String acctNo);

    /**
     * 个人账户 额度划拨记录
     */
    @GetMapping("/api/settle/personalAccount/info/searchAdjustRecord")
    PageTable<AdminSearchPersonalAdjustRecordResultDto> adminSearchAdjustRecord(@SpringQueryMap AdminSearchPersonalAdjustRecordDto searchParamDto);



    /**
     * 获得发放主体账户以及关联的信息
     *
     * @param userName 登录的主体账号对应的用户名
     */
    @GetMapping("/api/settle/personalAccount/manage/getIssueBodyAccountProfile")
    Response<SettleAccount> getIssueBodyAccountProfile(@RequestParam("userName") String userName);

    /**
     * 搜索个人账户列表
     */
    @GetMapping("/api/settle/personalAccount/manage/searchAccount")
    PageTable<AdminSearchPersonalAccountResultDto> adminSearchPersonalAccount(@SpringQueryMap AdminSearchPersonalAccountDto searchParamDto);



    /**
     * 批量启用/停用 账户
     *
     * @param acctNoList 批量操作的账户列表
     * @param newStatus  要更新的新状态
     */
    @GetMapping("/api/settle/personalAccount/manage/switchStatus")
    public Response<String> switchAccountStatus(@RequestParam("acctNoList") List<String> acctNoList, @RequestParam("newStatus") String newStatus);



    /**
     * 修改 个人账户扣减模式
     *
     * @param acctNo 个人账号
     * @param newDeductPattern 新的扣减模式
     */
    @GetMapping("/api/settle/personalAccount/manage/switchDeductPattern")
    Response<String> switchDeductPattern(@RequestParam("acctNo") String acctNo, @RequestParam("newDeductPattern") String newDeductPattern);



    /**
     * 批量修改 个人账户扣减模式
     *
     * @param acctNoList 个人账号列表
     * @param newDeductPattern 新的扣减模式
     */
    @GetMapping("/api/settle/personalAccount/manage/batchSwitchDeductPattern")
    Response<String> batchSwitchDeductPattern(@RequestParam("acctNoList") List<String> acctNoList, @RequestParam("newDeductPattern") String newDeductPattern);

    // =========  end of  个人账户 模块   ===========


    /**
     * 账户交易
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/trade")
    Response trade(@RequestBody @Validated AccountTradeReq req);


    /**
     * 分页查询账户
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/base/page")
    PageTable<SettleAccount> listPageAccount(@SpringQueryMap AccountSearchReq req);

    /**
     * 分页查询账户
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/base/all")
    Response<List<SettleAccount>> listAllAccount(@SpringQueryMap AccountSearchReq req);

    /**
     * 保存账户
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/base/save")
    Response saveAccount(@RequestBody AccountSaveReq req);



    /**
     * 修改团队账户状态
     * @param acctNo
     * @param status
     * @return
     */
    @GetMapping("/api/settle/account/team/switchStatus")
    Response switchTeamAccountStatus(@RequestParam("acctNo")String acctNo,@RequestParam("status")String status);


    /**
     * 根据账户编号获取所有的账户信息
     * @param acctNo
     * @return
     */
    @GetMapping("/api/settle/account/base/getByAcctNo")
    Response<SettleAccount> getAccountAllInfoByAcctNo(@RequestParam("acctNo")String acctNo);


    /**
     * 根据teamCode获取teamAccount
     * @param teamCode
     * @return
     */
    @GetMapping("/api/settle/account/team/getAccountByTeamCode")
    Response<SettleAccount> getTeamAccountByTeamCode(@RequestParam("teamCode")String teamCode);

    /**
     * 个人账户绑定团队
     * @param userNames
     * @param teamCode
     * @return
     */
    @GetMapping("/api/settle/account/team/boundTeam")
    Response boundTeam(@RequestParam("usernames") List<String> userNames,@RequestParam("teamCode")String teamCode);

    /**
     * 个人账户绑定团队
     * @param usernames
     * @return
     */
    @GetMapping("/api/settle/account/team/unboundTeam")
    Response unboundTeam(@RequestParam("usernames") List<String> usernames);

    /**
     * 更改发放主体
     * @param username
     * @param oldIssuingBodyCode
     * @param newIssuingBodyCode
     * @return
     */
    @GetMapping("/api/settle/account/changeIssuingBody")
    Response changeIssuingBody(@RequestParam("username")String username, @RequestParam("oldIssuingBodyCode")String oldIssuingBodyCode,@RequestParam("newIssuingBodyCode")String newIssuingBodyCode);

    /**
     * 更改名称
     * @param username
     * @param newName
     * @return
     */
    @GetMapping("/api/settle/account/changeName")
    Response changeName(@RequestParam("username")String username, @RequestParam("newName")String newName);


    /**
     * 账户调整记录查询
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/adjust/page")
    PageTable<AccountAdjustRecordListResp> listPageAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq req);

    /**
     * 账户调整记录不分页查询
     * @param req
     * @return
     */
    @PostMapping("/api/settle/account/adjust/all")
    Response<List<AccountAdjustRecordListResp>> listAllAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq req);


    // =========  start of  SettleAccountInfoController 模块   ===========
    @GetMapping("/api/settle/accountInfo/getByIssuingBodyCode")
    Response<SettleAccountInfo> getByIssuingBodyCode(@RequestParam("issuingBodyCode") String issuingBodyCode);
    // =========  end of  SettleAccountInfoController 模块   ===========


}
