package com.rocogz.syy.settlement.constant;

/**
 * <dl>
 * <dd>Description: 结算中心基础服务，常量类 service</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020-04-30 上午 7:44</dd>
 * <dd>@author：yifenrui</dd>
 * </dl>
 */
public class SettlementConstant {
    /**
     * 结算中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "settlement-service";

    /**
     * like查询通配符
     */
    public static final String LIKE_WILD_CARD = "%";

    /**
     * 自动发放的 操作人名字
     */
    public static final String SYSTEM_CREATE_NAME = "系统";

    /**
     * 账户校验Redis锁前缀
     */
    public static final String ACCT_TRADE_LOCK_KEY="acct:trade:lock:";


    /**
     * 启用/停用状态
     */
    public static class DictSwitchStatus {
        //字典类型编号
        public static final String TYPE_CODE = "COMMON_STATUS";

        //=== 下面是字典值

        //启用
        public static final String OPEN = "OPEN";

        //停用
        public static final String LOCK = "LOCK";

    }



    /**
     * 个人账户 扣减模式
     */
    public static class DictDeductPattern {
        //字典类型编号
        public static final String TYPE_CODE = "DEDUCTION_PATTERN";


        //=== 下面是字典值

        //扣除个人账户 余额
        public static final String DEDUCT_PERSONAL_BALANCE = "DEDUCT_PERSONAL_BALANCE";

        //扣减【发放主体账户】额度
        public static final String DEDUCT_ISSUE_BODY = "DEDUCT_ISSUE_BODY";

        //扣减【团队账户】额度
        public static final String DEDUCT_TEAM = "DEDUCT_TEAM";

    }

    /**
     * 调整记录类型
     */
    public static class  AccountAdjustType{

        public static final String TYPE_CODE = "account_adjust_type";

        /**
         * 增加
         */
        public static final String ADD = "ADD";

        /**
         * 减少
         */
        public static final String REDUCE = "REDUCE";

        /**
         * 划拨额度-划出
         */
        public static final String ALLOCATE_OUT = "ALLOCATE_OUT";

        /**
         * 划拨额度-划入
         */
        public static final String ALLOCATE_IN = "ALLOCATE_IN";

        /**
         * 收回额度-划出
         */
        public static final String ALLOCATE_BACK_OUT = "ALLOCATE_BACK_OUT";

        /**
         * 收回额度-划入
         */
        public static final String ALLOCATE_BACK_IN = "ALLOCATE_BACK_IN";

        /**
         * 自动划拨额度-划出
         */
        public static final String AUTO_ALLOCATE_OUT = "AUTO_ALLOCATE_OUT";

        /**
         * 自动划拨额度-划入
         */
        public static final String AUTO_ALLOCATE_IN = "AUTO_ALLOCATE_IN";

        /**
         * 自动收回额度-划出
         */
        public static final String AUTO_ALLOCATE_BACK_OUT = "AUTO_ALLOCATE_BACK_OUT";

        /**
         * 自动收回额度-划入
         */
        public static final String AUTO_ALLOCATE_BACK_IN = "AUTO_ALLOCATE_BACK_IN";

    }



    /**
     * 账户类型
     */
    public static class DictAccountType {

        public static final String TYPE_CODE = "account_type";

        //发放主体账户
        public static final String ISSUING_BODY = "ISSUING_BODY";

        //团队账户
        public static final String TEAM = "TEAM";

        //个人账户
        public static final String PERSON = "PERSON";

    }

    /**
     * 额度扣减时点字典数据
     */
    public static class DeductionTimeAppointDictData {
        //字典类型编号
        public static final String TYPE_CODE = "DEDUCTION_TIME_APPOINT";

        //=== 下面是字典值
        //发放时扣减
        public static final String DEDUCTION_ON_ISSUE = "DEDUCTION_ON_ISSUE";

        //领取时扣减
        public static final String DEDUCTION_ON_COLLECTION = "DEDUCTION_ON_COLLECTION";
    }


}
