package com.rocogz.syy.settlement.dto;

import lombok.Data;

import java.util.List;

/**
 * @author 尹世豪
 * @Description: 账户查询请求dto
 * @Package com.rocogz.syy.dto.account
 * @date 2021/4/8 14:57
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class AccountResDTO {
    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 发放主体编号（发放主体账户才有）
     */
    private List<String> issuingBodyCodeList;

    /**
     * 额度扣减时点(发放主体账户才有)
     */
    private String deductionTimeAppoint;

    /**
     * 账户状态
     */
    private String status;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序类型
     */
    private String sortType;

    /**
     * 发放主体权限数据
     */
    List<String> dataPermissions;

    private Integer page = 1;

    private Integer limit = 10;

}
