package com.rocogz.syy.settlement.dto.electronic.account;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/4/15 11:05</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class OperateElectronicAcct {
    /**
     * 业务号(保证唯一).
     */
    @NotEmpty
    private String bizCode;

    /**
     * 代理商编号/合作客户编号.
     */
    @NotEmpty
    private String linkCode;

    /**
     * 扣减金额.
     */
    @NotNull
    @Min(0)
    private BigDecimal amount;

    /**
     * 操作类型.
     */
    @NotEmpty
    private String operateType;

    /**
     * 操作人名称.
     */
    private String operateUserName;
}
