package com.rocogz.syy.settlement.entity.account;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 账户表
 * </p>
 *
 * @author yinshihao
 * @since 2021-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleAccount extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 账户编号
     */
    private String acctNo;

    /**
     * 账户类型
     * @see SettlementConstant.DictAccountType
     */
    private String acctType;

    /**
     * 总额度
     */
    private BigDecimal totalAmount;

    /**
     * 可用额度或未划拨额度
     */
    private BigDecimal balanceAmount;

    /**
     * 已用金额或已划拨额度
     */
    private BigDecimal usedAmount;

    /**
     * 已发放金额
     */
    private BigDecimal issuedAmount;

    /**
     * 已领取金额
     */
    private BigDecimal receivedAmount;

    /**
     * 已退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 已退款笔数
     */
    private Integer refundCount;

    /**
     *  已发放数量
     */
    private Integer issuedCount;

    /**
     *  已领取数量
     */
    private Integer receivedCount;


    /**
     * 账户状态
     * @see SettlementConstant.DictSwitchStatus
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    // ====以下为非PO属性

    //账户对应的账号信息
    @TableField(exist = false)
    private SettleAccountInfo  accountInfo;

    /**
     * 上级账户信息
     */
    @TableField(exist = false)
    private SettleSuperiorAccount  superiorAccountInfo;
}
