package com.rocogz.syy.settlement.entity.account;


import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.enums.AccountTradeLogResultEnum;
import com.rocogz.syy.settlement.enums.AccountTradeOperationEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2021/4/8 18:37</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleAccountTradeLog extends IdEntity {

    /**
     * 日志编号
     */
    private String logNo;

    /**
     * 业务编号
     */
    private String  businessNo;


    /**
     * 交易操作类型
     */
    private AccountTradeOperationEnum tradeOperationType;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 额度扣减模式
     */
    private String deductionPatten;

    /**
     * 操作账户编号
     */
    private String acctNo;


    /**
     * 团队账户编号
     */
    private String refTeamAcctNo;

    /**
     * 发放主体账户编号
     */
    private String refIssuingBodyAcctNo;


    /**
     * 交易结果
     */
    private AccountTradeLogResultEnum result;

    /**
     * 请求参数
     */
    private String reqJson;

    /**
     * 响应json
     */
    private String resJson;

    /**
     * 异常描述
     */
    private String errorMsg;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

}