package com.rocogz.syy.settlement.entity.account;


import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.settlement.constant.SettlementConstant;
import com.rocogz.syy.settlement.enums.AccountTradeRecordTypeEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2021/4/8 14:42</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleAccountTradeRecord extends IdEntity {


    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 日志编号
     */
    private String logNo;

    /**
     * 业务编号
     * @see
     */
    private String businessNo;

    /**
     * 流水类型
     */
    private AccountTradeRecordTypeEnum tradeType;

    /**
     * 流水归属账户编号
     */
    private String acctNo;

    /**
     * 流水归属账户类型
     * @see SettlementConstant.DictAccountType
     */
    private String acctType;

    /**
     * 团队编号
     */
    private String refTeamCode;

    /**
     * 发放主体编号
     */
    private String refIssuingBodyCode;

    /**
     * 团队账户编号
     */
    private String refTeamAcctNo;

    /**
     * 发放主体账户编号
     */
    private String refIssuingBodyAcctNo;

    /**
     * 额度扣减模式
     */
    private String deductionPatten;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 变更后总额度
     */
    private BigDecimal afterTotalAmount;

    /**
     * 变更后可用金额
     */
    private BigDecimal afterBalanceAmount;

    /**
     * 变更后已用金额
     */
    private BigDecimal afterUsedAmount;

    /**
     * 变更后已发放金额
     */
    private BigDecimal afterIssuedAmount;

    /**
     * 变更后已领取金额
     */
    private BigDecimal afterReceivedAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 操作人
     */
    private String createUser;

    /**
     * 操作时间
     */
    private LocalDateTime createTime;

    /**
     * 操作日期
     */
    private LocalDate createDate;

}