package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户收款用途明细表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SettleElectronicAccountCollectionRecordDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    /**
     * 电子账户类型对应的编码
     */
    private String linkCode;

    /**
     * 收款记录编码
     */
    private String collectionRecordCode;

    /**
     * 业务编号(借款记录编号/备付金充值记录编号)
     */
    private String bizCode;

    /**
     * 类型(DEBT:借款还款;RECHARGE:备付金充值)
     */
    private String type;

    /**
     * 业务对应的总金额(借款记录->借了多少钱；充值记录->充了多少钱)
     */
    private BigDecimal bizTotalAmount;

    /**
     * 使用金额
     */
    private BigDecimal usedAmount;

    /**
     * 业务对应的创建时间
     */
    private LocalDate bizCreateTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 收款金额
     */
    @TableField(exist = false)
    private BigDecimal recordCollectionAmount;

    /**
     * 收款日期
     */
    @TableField(exist = false)
    private LocalDate recordCollectionDate;
}
