package com.rocogz.syy.settlement.entity.electronicaccount;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电子账户信息表
 * </p>
 *
 * @author yifenrui
 * @since 2021-04-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("settle_electronic_account_info")
public class SettleElectronicAccountInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 电子账户编码
     */
    private String acctCode;

    @TableField(exist = false)
    private String acctName;



    /**
     * 电子账户状态(LOCK:停用;OPEN:启用)
     */
    private String acctStatus;

    /**
     * 电子账户关联类型(AGENT:代理商;CUSTOMER:合作客户)
     */
    private String linkType;

    /**
     * 电子账户类型对应的编码
     */
    private String linkCode;

    /**
     * 额度管理模式(VIRTUAL_MODE:虚拟额度;RESERVE_PAYMENT:备付金)
     */
    private String quotaMode;

    /**
     * 账户-余额
     */
    private BigDecimal acctBalance;

    /**
     * 账户-总额
     */
    private BigDecimal acctTotalAmount;

    /**
     * 账户-已使用总额
     */
    private BigDecimal acctTotalUsed;

    /**
     * 账户-退款总额
     */
    private BigDecimal acctTotalRefund;

    /**
     * 虚拟额度-余额
     */
    private BigDecimal virtualQuotaBalance;

    /**
     * 备付金-余额
     */
    private BigDecimal reservePaymentBalance;

    /**
     * 虚拟额度-总额
     */
    private BigDecimal virtualQuotaTotal;

    /**
     * 备付金-总额
     */
    private BigDecimal reservePaymentTotal;

    /**
     * 虚拟额度-已使用
     */
    private BigDecimal virtualQuotaUsed;

    /**
     * 备付金-已使用
     */
    private BigDecimal reservePaymentUsed;

    /**
     * 虚拟额度-退款
     */
    private BigDecimal virtualQuotaRefund;

    /**
     * 备付金-退款
     */
    private BigDecimal reservePaymentRefund;

    /**
     * 备付金-借款授信-余额
     */
    private BigDecimal reservePaymentDebtBalance;
    /**
     * 备付金-借款授信-总额
     */
    private BigDecimal reservePaymentDebtTotal;
    /**
     * 备付金-借款授信-已使用
     */
    private BigDecimal reservePaymentDebtUsed;
    /**
     * 备付金-借款授信-退款
     */
    private BigDecimal reservePaymentDebtRefund;
    /**
     * 备付金-收款充值-余额
     */
    private BigDecimal reservePaymentCashBalance;
    /**
     * 备付金-收款充值-总额
     */
    private BigDecimal reservePaymentCashTotal;
    /**
     * 备付金-收款充值-已使用
     */
    private BigDecimal reservePaymentCashUsed;
    /**
     * 备付金-收款充值-退款
     */
    private BigDecimal reservePaymentCashRefund;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 备注
     */
    private String remark;

    /**
     * 其他信息
     */
    @TableField(exist = false)
    private SettleElectronicAccountSummaryInfo settleElectronicAccountSummaryInfo;
    /**
     * 合作客户所属代理商
     */
    @TableField(exist = false)
    private String belongAgentName;

    /**
     * 合作客户类型
     */
    @TableField(exist = false)
    private String customerType;
}
