/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.settlement.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.settlement.dto.AccountAdjustRecordListResp;
import com.rocogz.syy.settlement.dto.AccountAdjustRecordSearchReq;
import com.rocogz.syy.settlement.dto.AccountOperationLogResDTO;
import com.rocogz.syy.settlement.dto.AccountProfileDto;
import com.rocogz.syy.settlement.dto.AccountResDTO;
import com.rocogz.syy.settlement.dto.AccountSaveReq;
import com.rocogz.syy.settlement.dto.AccountSearchReq;
import com.rocogz.syy.settlement.dto.AccountTradeReq;
import com.rocogz.syy.settlement.dto.AddAccountResDTO;
import com.rocogz.syy.settlement.dto.AdminSearchPersonalAccountDto;
import com.rocogz.syy.settlement.dto.AdminSearchPersonalAccountResultDto;
import com.rocogz.syy.settlement.dto.AdminSearchPersonalAdjustRecordDto;
import com.rocogz.syy.settlement.dto.AdminSearchPersonalAdjustRecordResultDto;
import com.rocogz.syy.settlement.dto.OperationAccountAmountDTO;
import com.rocogz.syy.settlement.dto.OperationAccountStatusDTO;
import com.rocogz.syy.settlement.dto.PersonAccountAmountResp;
import com.rocogz.syy.settlement.dto.TradeResp;
import com.rocogz.syy.settlement.dto.UpdateAccountResDTO;
import com.rocogz.syy.settlement.dto.electronic.account.ElectronicAccountCollectionRecordPageQuery;
import com.rocogz.syy.settlement.dto.electronic.account.OperateElectronicAcct;
import com.rocogz.syy.settlement.dto.electronic.account.RepaidCreditProvisionResultDto;
import com.rocogz.syy.settlement.dto.electronic.account.SettleElectronicAccountCollectionRecordWithDetail;
import com.rocogz.syy.settlement.dto.electronic.account.SettleElectronicAccountQuotaManualQueryDto;
import com.rocogz.syy.settlement.dto.electronic.account.SettleElectronicAccountQuotaProvisionQueryDto;
import com.rocogz.syy.settlement.dto.electronic.account.SettleElectronicAcctOrderRefundParamDto;
import com.rocogz.syy.settlement.entity.SettleSubject;
import com.rocogz.syy.settlement.entity.account.SettleAccount;
import com.rocogz.syy.settlement.entity.account.SettleAccountAdjustRecord;
import com.rocogz.syy.settlement.entity.account.SettleAccountInfo;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountCollectionRecord;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountCollectionRecordDetail;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountInfo;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountQuotaManual;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountQuotaProvision;
import com.rocogz.syy.settlement.entity.electronicaccount.SettleElectronicAccountSummaryInfo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public interface ISettlementClientService {
    @GetMapping(value={"/api/settle/subject"})
    public PageTable<SettleSubject> searchSettleSubject(@RequestParam(name="code", required=false) String var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="settleSubjectList", required=false) List<String> var3, @RequestParam(name="type", required=false) String var4, @RequestParam(name="status", required=false) String var5, @RequestParam(name="limit", defaultValue="20") Integer var6, @RequestParam(name="page", defaultValue="1") Integer var7);

    @PostMapping(value={"/api/settle/subject/switchSettleSubjectStatus"})
    public Response switchSettleSubjectStatus(@RequestBody SettleSubject var1);

    @PostMapping(value={"/api/settle/subject/deleteSettleSubject"})
    public Response deleteSettleSubject(@RequestParam(name="id") Integer var1);

    @PostMapping(value={"/api/settle/subject/createOrUpdateSettleSubject"})
    public Response createOrUpdateSettleSubject(@RequestBody SettleSubject var1);

    @GetMapping(value={"/api/settle/subject/detail/{id}"})
    public Response<SettleSubject> getSettleSubjectById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/settle/subject/{code}"})
    public Response<SettleSubject> getSettleSubjectByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/api/settle/subject/getSettleSubjectCode"})
    public Response<String> getSettleSubjectCode();

    @PostMapping(value={"/api/settle/subject/getCheckName"})
    public List<SettleSubject> getCheckName(@RequestParam(name="code") String var1, @RequestParam(name="type") String var2, @RequestParam(name="name") String var3);

    @GetMapping(value={"/api/settle/subject/settleSubjectList"})
    public Response<List<SettleSubject>> settleSubjectList();

    @PostMapping(value={"/api/settle/account/queryPage"})
    public PageTable<SettleAccount> accountPageTable(@RequestBody AccountResDTO var1);

    @PostMapping(value={"/api/settle/account/findAccountList"})
    public Response<List<SettleAccount>> findAccountList(@RequestBody AccountResDTO var1);

    @PostMapping(value={"/api/settle/account/saveSettleAccount"})
    public Response<SettleAccount> saveSettleAccount(@RequestBody AddAccountResDTO var1);

    @GetMapping(value={"/api/settle/account/editDeductionTimeAppoint"})
    public Response editDeductionTimeAppoint(@RequestParam(value="acctNos") List<String> var1, @RequestParam(value="deductionTimeAppoint") String var2, @RequestParam(value="updateUser") String var3);

    @PostMapping(value={"/api/settle/account/operateStatus"})
    public Response operateStatus(@RequestBody OperationAccountStatusDTO var1);

    @PostMapping(value={"/api/settle/account/operationAccountAmount"})
    public Response operationAccountAmount(@RequestBody OperationAccountAmountDTO var1);

    @GetMapping(value={"/api/settle/account/getAllInfoByAccNo"})
    public Response<SettleAccount> getAllInfoByAccNo(@RequestParam(value="acctNo") String var1);

    @PostMapping(value={"/api/settle/account/accountOperationLogPageTable"})
    public PageTable<SettleAccountAdjustRecord> accountOperationLogPageTable(@RequestBody AccountOperationLogResDTO var1);

    @GetMapping(value={"/api/settle/account/findByAccNos"})
    public Response<List<SettleAccount>> findByAccNos(@RequestParam(value="acctNos") List<String> var1);

    @RequestMapping(value={"/api/settle/account/deleteByTeamCode"})
    public Response deleteByTeamCode(@RequestParam(value="teamCode") String var1);

    @GetMapping(value={"/api/settle/account/getAllInfoByIssuingBodyCode"})
    public Response<SettleAccount> getAllInfoByIssuingBodyCode(@RequestParam(value="issuingBodyCode") String var1);

    @PostMapping(value={"/api/settle/account/updateByIssuingBodyCodeAndPCode"})
    public void updateByIssuingBodyCodeAndPCode(@RequestBody @Validated UpdateAccountResDTO var1);

    @GetMapping(value={"/api/settle/personalAccount/info/getPersonalAccountProfile"})
    public Response<AccountProfileDto> getPersonalAccountProfile(@RequestParam(value="userName") String var1);

    @GetMapping(value={"/api/settle/personalAccount/info/getPersonalAccountProfileByAcctNo"})
    public Response<AccountProfileDto> getPersonalAccountProfileByAcctNo(@RequestParam(value="acctNo") String var1);

    @GetMapping(value={"/api/settle/personalAccount/info/searchAdjustRecord"})
    public PageTable<AdminSearchPersonalAdjustRecordResultDto> adminSearchAdjustRecord(@SpringQueryMap AdminSearchPersonalAdjustRecordDto var1);

    @GetMapping(value={"/api/settle/personalAccount/manage/getIssueBodyAccountProfile"})
    public Response<SettleAccount> getIssueBodyAccountProfile(@RequestParam(value="userName") String var1);

    @GetMapping(value={"/api/settle/personalAccount/manage/searchAccount"})
    public PageTable<AdminSearchPersonalAccountResultDto> adminSearchPersonalAccount(@SpringQueryMap AdminSearchPersonalAccountDto var1);

    @GetMapping(value={"/api/settle/personalAccount/manage/switchStatus"})
    public Response<String> switchAccountStatus(@RequestParam(value="acctNoList") List<String> var1, @RequestParam(value="newStatus") String var2);

    @GetMapping(value={"/api/settle/personalAccount/manage/switchDeductPattern"})
    public Response<String> switchDeductPattern(@RequestParam(value="acctNo") String var1, @RequestParam(value="newDeductPattern") String var2);

    @GetMapping(value={"/api/settle/personalAccount/manage/batchSwitchDeductPattern"})
    public Response<String> batchSwitchDeductPattern(@RequestParam(value="acctNoList") List<String> var1, @RequestParam(value="newDeductPattern") String var2);

    @PostMapping(value={"/api/settle/account/getAccountByUsernameList"})
    public Response<List<SettleAccount>> getAccountByUsernameList(@RequestBody List<String> var1);

    @GetMapping(value={"/api/settle/account/getPersonAmountByUsername"})
    public Response<PersonAccountAmountResp> getPersonAmountByUsername(@RequestParam(value="username") String var1);

    @PostMapping(value={"/api/settle/account/trade"})
    public Response<TradeResp> trade(@RequestBody @Validated AccountTradeReq var1);

    @PostMapping(value={"/api/settle/account/base/page"})
    public PageTable<SettleAccount> listPageAccount(@SpringQueryMap AccountSearchReq var1);

    @PostMapping(value={"/api/settle/account/base/all"})
    public Response<List<SettleAccount>> listAllAccount(@SpringQueryMap AccountSearchReq var1);

    @PostMapping(value={"/api/settle/account/base/save"})
    public Response saveAccount(@RequestBody AccountSaveReq var1);

    @GetMapping(value={"/api/settle/account/team/switchStatus"})
    public Response switchTeamAccountStatus(@RequestParam(value="acctNo") String var1, @RequestParam(value="status") String var2);

    @GetMapping(value={"/api/settle/account/base/getByAcctNo"})
    public Response<SettleAccount> getAccountAllInfoByAcctNo(@RequestParam(value="acctNo") String var1);

    @GetMapping(value={"/api/settle/account/team/getAccountByTeamCode"})
    public Response<SettleAccount> getTeamAccountByTeamCode(@RequestParam(value="teamCode") String var1);

    @GetMapping(value={"/api/settle/account/team/boundTeam"})
    public Response boundTeam(@RequestParam(value="usernames") List<String> var1, @RequestParam(value="teamCode") String var2);

    @GetMapping(value={"/api/settle/account/team/unboundTeam"})
    public Response unboundTeam(@RequestParam(value="usernames") List<String> var1);

    @GetMapping(value={"/api/settle/account/changeIssuingBody"})
    public Response changeIssuingBody(@RequestParam(value="username") String var1, @RequestParam(value="oldIssuingBodyCode") String var2, @RequestParam(value="newIssuingBodyCode") String var3);

    @GetMapping(value={"/api/settle/account/changeName"})
    public Response changeName(@RequestParam(value="username") String var1, @RequestParam(value="newName") String var2);

    @GetMapping(value={"/api/settle/account/getByUsername"})
    public Response<SettleAccount> getAccountByUsername(@RequestParam(value="username") String var1);

    @PostMapping(value={"/api/settle/account/adjust/page"})
    public PageTable<AccountAdjustRecordListResp> listPageAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq var1);

    @PostMapping(value={"/api/settle/account/adjust/all"})
    public Response<List<AccountAdjustRecordListResp>> listAllAccountAdjustRecord(@SpringQueryMap AccountAdjustRecordSearchReq var1);

    @GetMapping(value={"/api/settle/accountInfo/getByIssuingBodyCode"})
    public Response<SettleAccountInfo> getByIssuingBodyCode(@RequestParam(value="issuingBodyCode") String var1);

    @GetMapping(value={"/api/settle/accountInfo/deleteIssuingBodyAcctCount"})
    public Response deleteIssuingBodyAcctCount(@RequestParam(value="issuingBodyCode") String var1);

    @PostMapping(value={"/electronic/settleElectronicAccountInfo/deductionByOrder"})
    public Response<String> deductionElectronicAcctBalanceByOrder(@Validated @RequestBody OperateElectronicAcct var1);

    @PostMapping(value={"/electronic/settleElectronicAccountInfo/refund"})
    public Response<String> electronicAcctRefund(@Validated @RequestBody SettleElectronicAcctOrderRefundParamDto var1);

    @GetMapping(value={"/electronic/settleElectronicAccountInfo/getByLinkCode"})
    public Response<SettleElectronicAccountInfo> getElectronicAcctByLinkCode(@RequestParam(value="linkCode") String var1);

    @PostMapping(value={"/electronic/settleElectronicAccountInfo/addElectronicAccountBalanceByLinkCode"})
    public Response<String> addElectronicAccountBalanceByLinkCode(@RequestBody OperateElectronicAcct var1);

    @GetMapping(value={"/electronic/settleElectronicAccountSummaryInfo/addGrantQuota"})
    public Response electronicAcctSummaryInfoAddGrantQuota(@RequestParam(value="linkCode") String var1, @RequestParam(value="amount") BigDecimal var2);

    @GetMapping(value={"/electronic/settleElectronicAccountSummaryInfo/addReceiveQuota"})
    public Response electronicAcctSummaryInfoAddReceiveQuota(@RequestParam(value="linkCode") String var1, @RequestParam(value="amount") BigDecimal var2);

    @GetMapping(value={"/electronic/settleElectronicAccountSummaryInfo/getByAcctCode"})
    public Response<SettleElectronicAccountSummaryInfo> getElectronicAcctSummaryInfoByAcctCode(@RequestParam(value="acctCode") String var1);

    @GetMapping(value={"/electronic/settleElectronicAccountSummaryInfo/getByLinkCode"})
    public Response<SettleElectronicAccountSummaryInfo> getElectronicAcctSummaryInfoByLinkCode(@RequestParam(value="linkCode") String var1);

    @PostMapping(value={"/electronic/settleElectronicAccountQuotaManual/pageQuery"})
    public PageTable<SettleElectronicAccountQuotaManual> settleElectronicAccountQuotaManualPageQuery(@RequestBody SettleElectronicAccountQuotaManualQueryDto var1);

    @PostMapping(value={"/electronic/settleElectronicAccountQuotaProvision/pageQuery"})
    public PageTable<SettleElectronicAccountQuotaProvision> settleElectronicAccountQuotaProvisionPageQuery(@RequestBody SettleElectronicAccountQuotaProvisionQueryDto var1);

    @GetMapping(value={"/electronic/settleElectronicAccountSummaryInfo/updateBalance2Redis"})
    public Response updateElectronicAcctBalance2Redis(@RequestParam(value="acctCode", required=false) String var1);

    @GetMapping(value={"/electronic/settleElectronicAccountQuotaProvision/getRepaidCreditProvisionList"})
    public Response<RepaidCreditProvisionResultDto> getRepaidCreditProvisionList(@RequestParam(value="linkCode") String var1, @RequestParam(value="amount") BigDecimal var2);

    @GetMapping(value={"/electronic/settleElectronicAccountInfo/accoutQueryPage"})
    public PageTable<SettleElectronicAccountInfo> accoutQueryPage(@RequestParam(value="linkCode", required=false) String var1, @RequestParam(value="sortCodeList", required=false) List<String> var2, @RequestParam(value="linkType", required=false) String var3, @RequestParam(value="acctCode", required=false) String var4, @RequestParam(value="quotaMode", required=false) String var5, @RequestParam(value="status", required=false) String var6, @RequestParam(value="dataPermissions", required=false) List<String> var7, @RequestParam(value="limit", defaultValue="20") Integer var8, @RequestParam(value="page", defaultValue="1") Integer var9);

    @PostMapping(value={"/electronic/settleElectronicAccountInfo/updateStatus"})
    public Response updateStatus(@RequestBody SettleElectronicAccountInfo var1);

    @PostMapping(value={"/electronic/settleElectronicAccountInfo/createSettleElectronicAccountInfo"})
    public Response createSettleElectronicAccountInfo(@RequestBody SettleElectronicAccountInfo var1);

    @GetMapping(value={"/electronic/settleElectronicAccountInfo/getSettleElectronicAccountInfoByAcctCode"})
    public Response<SettleElectronicAccountInfo> getSettleElectronicAccountInfoByAcctCode(@RequestParam(value="acctCode") String var1);

    @PostMapping(value={"/electronic/settleElectronicAccountQuotaManual/adjustQuota"})
    public Response adjustQuota(@RequestBody SettleElectronicAccountQuotaManual var1);

    @PostMapping(value={"/electronic/settleElectronicAccountQuotaProvision/adjustQuota"})
    public Response adjustQuotaProvision(@RequestBody SettleElectronicAccountQuotaProvision var1);

    @GetMapping(value={"/electronic/settleElectronicAccountInfo/getProvisionInfoByCode"})
    public Response<SettleElectronicAccountQuotaProvision> getProvisionInfoByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/electronic/settleElectronicAccountInfo/deleteElectronicAccountByLinkCode"})
    public Response deleteElectronicAccountByLinkCode(@RequestParam(value="linkCode") String var1);

    @PostMapping(value={"/electronic/settle-electronic-account-collection-record/pageQuery"})
    public PageTable<SettleElectronicAccountCollectionRecord> electronicAccountCollectionRecordPageTable(@RequestBody ElectronicAccountCollectionRecordPageQuery var1);

    @PostMapping(value={"/electronic/settle-electronic-account-collection-record/save"})
    public Response saveElectronicAccountCollectionRecord(@RequestBody SettleElectronicAccountCollectionRecord var1);

    @GetMapping(value={"/electronic/settle-electronic-account-collection-record/detail"})
    public Response<SettleElectronicAccountCollectionRecordWithDetail> getElectronicAccountCollectionRecordDetail(@RequestParam(value="recordCode") String var1);

    @GetMapping(value={"/electronic/settle-electronic-account-collection-record/listDetailByBizCode"})
    public Response<List<SettleElectronicAccountCollectionRecordDetail>> listElectronicAccountCollectionRecordDetailByBizCode(@RequestParam(value="bizCode") String var1);
}

