package com.rocogz.syy.settlement.dto;

import com.rocogz.syy.settlement.enums.AccountTradeOperationEnum;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>账户交易基础请求实体类</p>
 * @author djt
 * @date 2021/4/8
 */
@Data
public class AccountTradeReq {

    /**
     * 交易操作
     */
    @NotNull
    private AccountTradeOperationEnum accountTradeOperation;

    /**
     * 交易金额
     */
    @NotNull
    @DecimalMin("0.01")
    @Digits(integer = 12,fraction = 3,message = "账户金额有误")
    private BigDecimal amount;


    /**
     * 创建人
     */
    private String createUser;

    /**
     * 备注
     */
    @Length(max = 500)
    private String remark;


    /**
     * 操作账户编号
     */
    private String acctNo;


    /**
     * 业务编号 发放/领取/作废操作必传
     */
    private String businessNo;

    /**
     * 用户名
     */
    private String username;

    /**
     * 冻结列表 冻结/解冻操作必传
     */
    private List<AccountFreezeDTO>  freezeList;


    /**
     * 申请清单编号  发放操作的时候必传
     */
    private String applyDetailCode;

    /**
     * 跨层级划拨 参数
     */
    @Valid
    private AccountCrossLevelAllocateParam crossLevelAllocateParam;


}
