package com.rocogz.syy.settlement.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;

/**
 * 个人账户 管理员搜索基类
 * @author zhangmin
 *@date 2021/4/8
 */
@Setter @Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public abstract class AdminSearchPersonalBaseDto {

    private Boolean export = Boolean.FALSE;

    private Integer limit = 20;

    private Integer page = 1;

    /**
     * 排序字段
     */
    private String sortField;

    /**
     * 排序方式：ASC/DESC
     */
    private String sortType;

    /**
     * 团队编号【精确匹配】
     */
    private String teamCode;

    /**
     * 团队编号参数
     */
    private String teamCodeParam;


    /**
     * 团队账户编号【精确匹配】
     */
    @JsonIgnore
    private String teamAccountNo;

}
