package com.rocogz.syy.settlement.dto;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author 尹世豪
 * @Description: 调整发放主体账户额度dto
 * @Package com.rocogz.syy.dto.account
 * @date 2021/4/8 14:57
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
public class OperationAccountAmountDTO {

    /**
     * 流水类型
     */
    @NotBlank(message = "账户编号不能为空")
    private String tradeType;

    /**
     * 流水归属账户编号
     */
    @NotBlank(message = "流水归属账户编号不能为空")
    private String acctNo;

    /**
     * 流水归属账户类型
     */
    @NotBlank(message = "流水归属账户类型编号不能为空")
    private String acctType;

    /**
     * 发放主体编号
     */
    @NotBlank(message = "账户编号不能为空")
    private String refIssuingBodyCode;

    /**
     * 发放主体账户编号
     */
    @NotBlank(message = "账户编号不能为空")
    private String refIssuingBodyAcctNo;

    /**
     * 金额
     */
    @NotNull(message = "操作人不能为空")
    private BigDecimal amount;

    /**
     * 备注
     */
    @Length(max = 500,message = "备注不得超过500个字符")
    private String remark;

    /**
     * 操作人
     */
    @NotNull(message = "操作人不能为空")
    private Integer createUser;

    /**
     * 操作时间
     */
    @NotNull(message = "操作时间不能为空")
    private LocalDateTime createTime;

    /**
     * 操作日期
     */
    @NotNull(message = "操作日期不能为空")
    private LocalDate createDate;

}
