package com.rocogz.syy.settlement.dto.invoicematter;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 新增开票事项Dto
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
public class InvoiceMatterReqDto {

    /**
     * 编码
     */
    private String code;

    /**
     * 前一个状态
     */
    private String preStatus;

    /**
     * 当前状态
     */
    @NotBlank(message = "事项状态不能为空")
    private String status;

    /**
     * 服务商编号
     */
    @NotBlank(message = "服务商编号不能为空")
    private String agentCode;

    /**
     * 发放主体编号
     */
    @NotBlank(message = "发放主体编号不能为空")
    private String issuingBodyCode;

    /**
     * 结算主体编号
     */
    @NotBlank(message = "结算主体编号不能为空")
    private String settleSubjectCode;

    /**
     * 业务归属年份
     */
    @NotBlank(message = "业务归属年份不能为空")
    private String businessYear;

    /**
     * 业务归属月份
     */
    private String businessMonth;

    /**
     * 事项附件列表
     */
    private List<InvoiceMatterAttachDto> matterAttchs;

    /**
     * 开票事项备注
     */
    @Length(max = 200, message = "开票事项备注长度不能超过200")
    private String matterRemark;

    /**
     * 发票代码
     */
    @NotBlank(message = "发票代码不能为空")
    private String invoiceCode;

    /**
     * 发票号码
     */
    @NotBlank(message = "发票号码不能为空")
    private String invoiceNo;

    /**
     * 付款方
     */
    @NotBlank(message = "付款方不能为空")
    private String payer;

    /**
     * 收款方
     */
    @NotBlank(message = "收款方不能为空")
    private String payee;

    /**
     * 发票类型
     */
    @NotBlank(message = "发票类型不能为空")
    private String invoiceType;

    /**
     * 发票税率
     */
    @NotNull(message = "发票税率不能为空")
    @DecimalMin(value = "0", message = "发票税率需大于0")
    private BigDecimal invoiceTaxRate;

    /**
     * 发票金额
     */
    @NotNull(message = "发票金额不能为空")
    @DecimalMin(value = "0", message = "发票金额需大于0")
    private BigDecimal invoiceAmount;

    /**
     * 发票税额
     */
    @NotNull(message = "发票税额不能为空")
    @DecimalMin(value = "0", message = "发票税额需大于0")
    private BigDecimal invoiceTaxAmount;

    /**
     * 发票含税金额
     */
    @NotNull(message = "发票含税金额不能为空")
    @DecimalMin(value = "0", message = "发票含税金额需大于0")
    private BigDecimal invoiceIncludeTaxAmount;

    /**
     * 开票日期
     */
    @NotNull(message = "开票日期不能为空")
    private LocalDate invoicingTime;

    /**
     * 发票图片
     */
    private String invoiceImagePath;

    /**
     * 发票说明
     */
    private String invoiceRemark;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
