package com.rocogz.syy.settlement.dto.invoicematter;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 更新发票收款信息
 * @date：2021/9/8
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
public class UpdateReceiptReqDto {

    /**
     * 收款单号
     */
    @NotBlank(message = "收款单号不能为空")
    private String receiptCode;

    /**
     * 收款到账日期
     */
    @NotNull(message = "收款到账日期不能为空")
    private LocalDate receiptTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 开票事项code列表
     */
    @Valid
    @NotEmpty(message = "开票事项编号不能为空")
    private List<String> invoiceMatterCodes;
}
